/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.contract.local.utils.contract;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.contract.local.entity.contract.Contract;
import com.biz.crm.dms.business.contract.sdk.dto.contract.ContractDto;
import com.biz.crm.dms.business.contract.sdk.enums.ActApproveStatusExtendEnum;
import com.biz.crm.dms.business.contract.sdk.enums.EffectiveStatusEnum;
import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractVo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.Validate;

public class ContractUtil {
    public static void validateAdd(ContractDto contractDto) {
        Validate.notNull((Object)contractDto, (String)"\u5408\u540c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)contractDto.getContractName(), (String)"\u5408\u540c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)contractDto.getTemplateCode(), (String)"\u5408\u540c\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)contractDto.getElementDataMap(), (String)"\u5408\u540c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)contractDto.getCusCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)contractDto.getContractType(), (String)"\u5408\u540c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)contractDto.getContractYear(), (String)"\u5408\u540c\u5e74\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)contractDto.getYearType(), (String)"\u5408\u540c\u5e74\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)contractDto.getStartTime(), (String)"\u5408\u540c\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)contractDto.getEndTime(), (String)"\u5408\u540c\u6709\u6548\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((contractDto.getStartTime().compareTo(contractDto.getEndTime()) < 0 ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Validate.isTrue((format.format(date).compareTo(contractDto.getEndTime()) < 0 ? 1 : 0) != 0, (String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f", (Object[])new Object[0]);
    }

    public static void validateEdit(ContractDto contractDto) {
        ContractUtil.validateAdd(contractDto);
        Validate.notBlank((CharSequence)contractDto.getId(), (String)"\u7f16\u8f91\u65f6\uff0c\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)contractDto.getContractCode(), (String)"\u7f16\u8f91\u65f6\uff0c\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    public static void validateSignContract(ContractVo contractVo) {
        Validate.notNull((Object)contractVo, (String)"\u5408\u540c\u8be6\u60c5\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)Integer.valueOf(BooleanEnum.FALSE.getNumStr()).equals(contractVo.getCancellationState()), (String)"\u5408\u540c\u5df2\u4f5c\u5e9f", (Object[])new Object[0]);
        Validate.isTrue((boolean)EnableStatusEnum.ENABLE.getCode().equals(contractVo.getEnableStatus()), (String)"\u5408\u540c\u5df2\u7981\u7528", (Object[])new Object[0]);
        Validate.isTrue((boolean)DelFlagStatusEnum.NORMAL.getCode().equals(contractVo.getDelFlag()), (String)"\u5408\u540c\u5df2\u5220\u9664", (Object[])new Object[0]);
        Validate.isTrue((boolean)ActApproveStatusExtendEnum.SIGN_NO_LEAGUE.getDictCode().equals(contractVo.getContractStatus()), (String)"\u5408\u540c\u4e0d\u662f\u5f85\u7b7e\u7ea6\u72b6\u6001", (Object[])new Object[0]);
        Validate.isTrue((boolean)EffectiveStatusEnum.EFFECTIVE_STAY.getKey().equals(contractVo.getEffectiveStatus()), (String)"\u5408\u540c\u4e0d\u662f\u5f85\u751f\u6548\u72b6\u6001\uff01", (Object[])new Object[0]);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String nowDate = format.format(new Date());
        Validate.isTrue((nowDate.compareTo(contractVo.getEndTime()) <= 0 ? 1 : 0) != 0, (String)"\u5408\u540c\u6709\u6548\u671f\u5df2\u8fc7\u4e0d\u80fd\u7b7e\u7ea6\uff01", (Object[])new Object[0]);
    }

    public static void getExpireEminderDate(Contract entity) {
        if (BooleanEnum.TRUE.getNumStr().equals(entity.getExpirationReminder())) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Integer expirationReminderNum = entity.getExpirationReminderNum();
            Calendar calendar = Calendar.getInstance();
            try {
                calendar.setTime(format.parse(entity.getEndTime()));
                calendar.set(6, calendar.get(6) - expirationReminderNum);
                entity.setExpirationReminderDate(format.format(calendar.getTime()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }
}

