package com.biz.crm.dms.business.contract.sdk.dto.contract;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 合同附加文件Dto
 *
 * @author ning.zhang
 * @date 2022/8/16
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "合同附加文件Dto")
public class ContractAdditionalFileDto extends TenantDto {

  /**
   * 合同ID
   */
  @ApiModelProperty(value = "合同ID")
  private String contractId;

  /**
   * 文件类型key
   */
  @ApiModelProperty("文件类型")
  private String fileType;

  /**
   * 附加文件列表
   */
  @ApiModelProperty("附加文件列表")
  private List<ContractAdditionalFileInfoDto> fileList;
}
