package com.biz.crm.dms.business.contract.sdk.dto.contracttemplateelement;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @description: 合同模板要素dto
 * @author: rentao
 * @date: 2021/11/18 14:43
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ContractFilesDto", description = "合同模板要素dto")
public class ContractTemplateElementDto extends TenantFlagOpDto {
  /**
   * 合同模板编码
   */
  @ApiModelProperty("合同模板编码")
  private String templateCode;

  /**
   * 合同要素编码
   */
  @ApiModelProperty("合同要素编码")
  private String elementCode;

  /**
   * 合同要素名称
   */
  @ApiModelProperty("合同要素名称")
  private String elementName;

  /**
   * 数据检索编码
   */
  @ApiModelProperty("数据检索编码")
  private String elementIndex;

  /**
   * 要素类要素组件名称型
   */
  @ApiModelProperty("要素组件名称")
  private String  elementComponentName;

  /**
   * 要素在模板中展示顺序
   */
  @ApiModelProperty("要素在模板中展示顺序")
  private Integer indexCode;

}
