package com.biz.crm.dms.business.contract.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @description: 合同状态扩展 
 * @author: rentao
 * @date: 2022/4/29 10:22
 */
public enum ActApproveStatusExtendEnum {

  /**
   * 未推送
   * */
  PUSH_NO_CONTRACT("NOPUSH","NOPUSH", "未推送","1"),

  /**
   * 推送失败
   * */
  PUSH_FAIL_CONTRACT("FAILPUSH","FAILPUSH", "推送失败","3"),

  /**
   * 已签约
   * */
  SIGN_CONTRACT("SIGN","SIGN", "已签约","4"),

  /**
   * 未签约
   * */
  SIGN_NO_LEAGUE("NOSIGN","NOSIGN", "未签约","5"),
  ;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  ActApproveStatusExtendEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 ContractSignState
   *
   * @param key
   * @return
   */
  public static ActApproveStatusExtendEnum getByKey(String key) {
    return Arrays
        .stream(ActApproveStatusExtendEnum.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }

}
