package com.biz.crm.dms.business.contract.sdk.enums;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

/**
 * @description: 作废状态
 * @author: rentao
 * @date: 2021/12/17 15:47
 */
public enum ContractCancellationState {

  CANCELLATION (0, "0","否","0"),
  NOT_CANCELLATION(1,"1", "是","1"),
  ;


  private Integer key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  ContractCancellationState(Integer key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public Integer getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 ContractCancellationState
   *
   * @param key
   * @return
   */
  public static ContractCancellationState getByKey(String key) {
    return Arrays.stream(ContractCancellationState.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }

}
