package com.biz.crm.dms.business.contract.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @description: 合同生效状态
 * @author: rentao
 * @date: 2022/4/28 11:07
 */
public enum EffectiveStatusEnum {

  EFFECTIVE_STAY("effective_stay", "effective_stay", "待生效", "1"),
  EFFECTIVE_ACTIVE("effective_active", "effective_active", "生效中", "2"),
  EFFECTIVE_LOSE("effective_lose", "effective_lose", "已失效", "2"),
  ;

  private String key;

  /**
   * 字典编码
   */
  private String dictCode;

  /**
   * 字典值
   */
  private String value;

  /**
   * 字典排序
   */
  private String order;

  EffectiveStatusEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 ContractYearType
   *
   * @param key
   * @return
   */
  public static EffectiveStatusEnum getByKey(String key) {
    return Arrays.stream(EffectiveStatusEnum.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }
}
