package com.biz.crm.dms.business.contract.sdk.event.contract;

import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractVo;

import java.util.List;

/**
 * @description: 合同信息变更事件通知接口
 * @author: rentao
 * @date: 2021/11/15 15:06
 */
public interface ContractEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(ContractVo vo) {
  }

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(ContractVo oldVo, ContractVo newVo) {
  }

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<ContractVo> list) {
  }

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<ContractVo> list) {
  }

  /**
   * 合同到期
   * @param list
   */
  default void onMaturity(List<ContractVo> list) {
  }

  /**
   * 合同生效
   * @param list
   */
  default void onEffective(List<ContractVo> list) {
  }

}
