package com.biz.crm.dms.business.contract.sdk.register.contract;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractAdditionalFileInfoVo;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 合同附加文件注册器(实现不同文件类型的动态扩展)
 *
 * @author ning.zhang
 * @date 2022/8/16
 */
public interface ContractAdditionalFileRegister {

  /**
   * 获取不同附加文件实现模块的key值
   *
   * @return 附加文件实现模块的key值
   */
  String getAdditionalTypeKey();


  /**
   * 获取不同附加文件实现模块名
   *
   * @return 附加文件实现模块名
   */
  String getAdditionalTypeName();

  /**
   * 创建附加文件时触发
   * 若扩展的附加文件模块需要保存关联的扩展数据,通过此接口实现关联数据保存
   * 附加文件保存会删除历史记录,所以实现模块也要删除相应关联历史记录
   *
   * @param vos 附加文件集合
   */
  void onCreate(List<ContractAdditionalFileInfoVo> vos);

  /**
   * 通过附加文件编码获取附加文件模块扩展数据(key:文件编码,value:附加文件模块扩展数据)
   *
   * @param additionalFileCodes 附加文件编码
   * @return 附加文件模块扩展数据
   */
  Map<String, JSONObject> onRequestByAdditionalFileCodes(Set<String> additionalFileCodes);
}
