package com.biz.crm.dms.business.contract.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.contract.sdk.dto.contract.ContractCustomerDto;
import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @description: 合同vo Service
 * @author: rentao
 * @date: 2021/11/23 17:27
 */
public interface ContractVoService {

  /**
   * 根据id查询合同模板
   *
   * @param id
   * @return
   */
  ContractVo findById(String id);

  /**
   * 合同编码查询合同
   *
   * @param contractCode
   * @author rentao
   * @date
   */
  List<ContractVo> findByContractCodes(List<String> contractCode);

  /**
   * 根据合同编码查询详情
   *
   * @param code 合同编码
   * @return
   */
  ContractVo findDetailsByCode(String code);

  /**
   * 根据模板编码查询合同列表
   *
   * @param templateCodes 模板编码查询
   * @return
   */
  List<ContractVo> findByTemplateCode(List<String> templateCodes);

  /**
   * 客户-合同分页查询
   *
   * @param pageable
   * @param contractCustomerDto
   * @return
   */
  Page<ContractVo> findByContractCustomerDto(Pageable pageable, ContractCustomerDto contractCustomerDto);

  /**
   * 客户-待签署合同数量
   * @param contractCustomerDto
   * @return
   */
  Integer findUnsignedCountByCurrentCustomer(ContractCustomerDto contractCustomerDto);

  /**
   * 找到有效客户代码
   * 根据经销商编码查询生效的合同集合
   *
   * @param customerCode 客户代码
   * @return {@link List}<{@link ContractVo}>
   */
  List<ContractVo> findEffectiveByCustomerCode(String customerCode);
}
