package com.biz.crm.dms.business.contract.sdk.vo.contract;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.vo.FileVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 合同附加文件vo
 *
 * @author ning.zhang
 * @date 2022/8/16
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "合同附加文件vo")
public class ContractAdditionalFileInfoVo extends FileVo {

  private static final long serialVersionUID = 3765152117008960772L;

  /**
   * 附加文件编码
   */
  @ApiModelProperty(value = "附加文件编码")
  private String additionalFileCode;

  /**
   * 排序(值越小越靠前)
   */
  @ApiModelProperty("排序(值越小越靠前)")
  private Integer sortIndex;

  /**
   * 附加类型key(不同附加文件实现模块的key值)
   */
  @ApiModelProperty("附加类型key(不同附加文件实现模块的key值)")
  private String additionalTypeKey;

  /**
   * 附加模块扩展json数据
   */
  @ApiModelProperty("附加模块扩展json数据")
  private JSONObject additionalJson;
}
