package com.biz.crm.dms.business.contract.sdk.vo.contract;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 合同附加类型文件vo
 *
 * @author ning.zhang
 * @date 2022/8/17
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "合同附加类型文件vo")
public class ContractAdditionalFileVo extends TenantVo {

  private static final long serialVersionUID = 1458315253515874875L;

  /**
   * 合同ID
   */
  @ApiModelProperty(value = "合同ID")
  private String contractId;

  /**
   * 文件类型key
   */
  @ApiModelProperty("文件类型")
  private String fileType;

  /**
   * 附加文件列表
   */
  @ApiModelProperty("附加文件列表")
  private List<ContractAdditionalFileInfoVo> fileList;
}
