package com.biz.crm.dms.business.contract.sdk.vo.contractelementdata;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;


/**
 * 合同地址联系人要素数据Vo
 *
 * @author ning.zhang
 * @date 2022/8/15
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "合同地址联系人要素数据Vo")
public class ContractAddressContactDataVo extends ContractElementDataVo {

  /**
   * 合同编码
   */
  @ApiModelProperty(value = "合同编码")
  private String contractCode;

  /**
   * 供方法定地址
   */
  @ApiModelProperty("供方法定地址")
  private String supplierLegalAddress;

  /**
   * 供方联系人
   */
  @ApiModelProperty("供方联系人")
  private String supplierContact;

  /**
   * 供方电话
   */
  @ApiModelProperty("供方电话")
  private String supplierPhone;

  /**
   * 供方邮箱
   */
  @ApiModelProperty("供方邮箱")
  private String supplierEmail;

  /**
   * 供方传真
   */
  @ApiModelProperty("供方传真")
  private String supplierFax;

  /**
   * 需方法定地址
   */
  @ApiModelProperty("需方法定地址")
  private String buyerLegalAddress;

  /**
   * 需方联系人
   */
  @ApiModelProperty("需方联系人")
  private String buyerContact;

  /**
   * 需方电话
   */
  @ApiModelProperty("需方电话")
  private String buyerPhone;

  /**
   * 需方邮箱
   */
  @ApiModelProperty("需方邮箱")
  private String buyerEmail;

  /**
   * 需方传真
   */
  @ApiModelProperty("需方传真")
  private String buyerFax;

}
