package com.biz.crm.dms.business.contract.sdk.vo.contractelementdata;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;


/**
 * @description: 合同签署栏
 * @author: rentao
 * @date: 2021/11/24 10:05
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "合同签署栏vo")
public class ContractSignBarDataVo extends ContractElementDataVo {

  @ApiModelProperty("合同签署栏id")
  private String id;

  /**
   * 甲方签名
   */
  @ApiModelProperty(name = "firstPartyName", value = "甲方签名", required = true)
  private String  firstPartyName;

  /**
   * 甲方授权代表
   */
  @ApiModelProperty(name = "firstPartyAuthorized", value = "甲方授权代表", required = true)
  private String  firstPartyAuthorized;

  /**
   * 甲方签署日期
   */
  @ApiModelProperty(name = "firstPartySignDate", value = "甲方签署日期", required = true)
  private String  firstPartySignDate;

  /**
   * 乙方签名
   */
  @ApiModelProperty(name = "secondPartyName", value = "乙方签名", required = true)
  private String  secondPartyName;

  /**
   * 乙方授权代表
   */
  @ApiModelProperty(name = "secondPartyAuthorized", value = "乙方签名", required = true)
  private String  secondPartyAuthorized;

  /**
   * 乙方签署日期
   */
  @ApiModelProperty(name = "secondPartySignDate", value = "乙方签署日期", required = true)
  private String  secondPartySignDate;

}
