package com.biz.crm.dms.business.contract.sdk.dto.contract;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.vo.AttachmentVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;
import java.util.Map;

/**
 * @description: 合同dto
 * @author: rentao
 * @date: 2021/11/16 14:21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ContractDto", description = "合同dto")
public class ContractDto extends TenantFlagOpDto {

  /**
   * 工作流参数
   */
  @ApiModelProperty("工作流参数")
  private ProcessBusinessDto processBusiness;

  /**
   * 合同编码
   */
  @ApiModelProperty(name = "contractCode", value = "合同编码", required = true)
  private String contractCode;

  /**
   * 合同名称
   */
  @ApiModelProperty(name = "contractName", value = "合同名称", required = true)
  private String contractName;

  /**
   * 模板编码
   */
  @ApiModelProperty(name = "templateCode", value = "模板编码", required = true)
  private String templateCode;

  /**
   * 合同类型
   */
  @ApiModelProperty(name = "contractType", value = "合同类型", required = true)
  private String contractType;

  /**
   * 合同年度
   */
  @ApiModelProperty(name = "contractYear", value = "合同年度", required = true)
  private String contractYear;

  /**
   * 年度类型
   */
  @ApiModelProperty(name = "yearType", value = "年度类型", required = true)
  private String yearType;

  /**
   * 客户编码
   */
  @ApiModelProperty(name = "cusCode", value = "客户编码", required = true)
  private String cusCode;

  /**
   * 客户名称
   */
  @ApiModelProperty(name = "cusName", value = "客户名称", required = true)
  private String cusName;

  /**
   * 渠道类型
   */
  @ApiModelProperty(name = "channelCode", value = "渠道编码", required = true)
  private String channelCode;

  /**
   * 渠道名称
   */
  @ApiModelProperty(name = "channelName", value = "渠道名称", required = true)
  private String channelName;

  /**
   * 所属组织编码
   */
  @ApiModelProperty(name = "orgCode", value = "所属组织编码", required = true)
  private String orgCode;

  /**
   * 所属组织名称
   */
  @ApiModelProperty(name = "orgName", value = "所属组织名称", required = true)
  private String orgName;

  /**
   * 合同开始时间
   */
  @ApiModelProperty(name = "startTime", value = "合同开始时间", required = true)
  private String startTime;

  /**
   * 合同结束时间
   */
  @ApiModelProperty(name = "endTime", value = "合同结束时间", required = true)
  private String endTime;

  /**
   * 对接人
   */
  @ApiModelProperty(name = "dockingPeople", value = "对接人", required = true)
  private String dockingPeople;

  /**
   * 客户法律代表
   */
  @ApiModelProperty(name = "cusLegalRepresentative", value = "客户法律代表", required = true)
  private String cusLegalRepresentative;

  /**
   * 客户联系方式
   */
  @ApiModelProperty(name = "cusContact", value = "客户联系方式", required = true)
  private String cusContact;

  /**
   * 客户联系人
   */
  @ApiModelProperty(name = "cusContactPerson", value = "客户联系人", required = true)
  private String cusContactPerson;

  /**
   * 客户统一信用证代码
   */
  @ApiModelProperty(name = "cusContact", value = "客户统一信用证代码", required = true)
  private String cusSocialConfidenceCode;

  /**
   * 客户地址
   */
  @ApiModelProperty(name = "cusAddress", value = "客户地址", required = true)
  private String cusAddress;

  /**
   * 客户开户行
   */
  @ApiModelProperty(name = "cusOpenBank", value = "客户开户行", required = true)
  private String cusOpenBank;

  /**
   * 客户开户账号
   */
  @ApiModelProperty(name = "cusOpenBankNo", value = "客户开户账号", required = true)
  private String cusOpenBankNo;

  /**
   * 甲方统一信用证代码
   */
  @ApiModelProperty(name = "fp_social_confidence_code", value = "甲方统一信用证代码", required = true)
  private String fpSocialConfidenceCode;

  /**
   * 甲方地址
   */
  @ApiModelProperty(name = "fpAddress", value = "甲方地址", required = true)
  private String fpAddress;

  /**
   * 甲方开户行
   */
  @ApiModelProperty(name = "fpOpenBank", value = "甲方开户行", required = true)
  private String fpOpenBank;

  /**
   * 甲方开户账号
   */
  @ApiModelProperty(name = "fpOpenBankNo", value = "甲方开户账号", required = true)
  private String fpOpenBankNo;

  /**
   * 甲方公司名称
   */
  @ApiModelProperty(name = "fpCompanyName", value = "甲方公司名称", required = true)
  private String fpCompanyName;

  /**
   * 甲方客服电话
   */
  @ApiModelProperty(name = "fpServiceTel", value = "甲方客服电话", required = true)
  private String fpServiceTel;

  /**
   * 省编码
   */
  @ApiModelProperty(name = "provinceCode", value = "省编码", required = true)
  private String provinceCode;

  /**
   * 省
   */
  @ApiModelProperty(name = "province", value = "省", required = true)
  private String province;

  /**
   * 市编码
   */
  @ApiModelProperty(name = "cityCode", value = "市编码", required = true)
  private String cityCode;

  /**
   * 市
   */
  @ApiModelProperty(name = "city", value = "市", required = true)
  private String city;

  /**
   * 区县编码
   */
  @ApiModelProperty(name = "districtCode", value = "区县编码", required = true)
  private String districtCode;

  /**
   * 区县
   */
  @ApiModelProperty(name = "district", value = "区县", required = true)
  private String district;

  /**
   * 到期提醒
   */
  @ApiModelProperty(name = "expirationReminder", value = "到期提醒", required = true)
  private String expirationReminder;

  /**
   * 到期提醒天数
   */
  @ApiModelProperty(name = "expirationReminderNum", value = "到期提醒天数", required = true)
  private Integer expirationReminderNum;

  /**
   * 到期提醒日期
   */
  @ApiModelProperty(name = "expirationReminderDate", value = "到期提醒日期", required = true)
  private String expirationReminderDate;

  /**
   * 合同签署方式
   */
  @ApiModelProperty(name = "contractSignType", value = "合同签署方式", required = true)
  private String contractSignType;

  /**
   * 是否作废 0否1是
   */
  @ApiModelProperty(name = "cancellationState", value = "是否作废 0否1是", required = true)
  private Boolean cancellationState;

  /**
   * 注册地址
   */
  @ApiModelProperty("注册地址")
  private String registeredAddress;

  /**
   * 菜单编码
   */
  @ApiModelProperty("菜单编码")
  private String competenceCode;

  /**
   * 合同状态
   */
  @ApiModelProperty("合同状态")
  private String contractStatus;

  /**
   * 生效状态
   */
  @ApiModelProperty("生效状态")
  private String effectiveStatus;

  /**
   * 流程附件信息
   */
  @ApiModelProperty(value = "流程附件信息")
  private List<AttachmentVo> attachmentVos;

  /**
   * 文件pdf唯一标识
   */
  @ApiModelProperty("文件pdf唯一标识")
  private String failedFileCode;

  /**
   * html页面
   */
  @ApiModelProperty(value = "html页面")
  private String htmlStr;

  /**
   * 要素内容
   */
  @ApiModelProperty
  private Map<String, JSONObject> elementDataMap;
}
