package com.biz.crm.dms.business.contract.sdk.dto.contracttemplate;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.dms.business.contract.sdk.dto.contracttemplateelement.ContractTemplateElementDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @description: 合同模板dto
 * @author: rentao
 * @date: 2021/11/16 14:18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ContractTemplateDto", description = "合同模板dto")
public class ContractTemplateDto extends TenantFlagOpDto {
  /**
   * 编码
   */
  @ApiModelProperty(name = "templateCode", value = "合同模板编码", required = true)
  private String templateCode;

  /**
   * 名称
   */
  @ApiModelProperty(name = "templateName", value = "合同模板名称", required = true)
  private String templateName;

  /**
   * 合同签署方式
   * */
  @ApiModelProperty(name = "contractSignType", value = "合同签署方式 '1'电子合同签署 '2'短信验证签署 '3' 线上签署 数据字典contract_sign_type", required = true)
  private String  contractSignType;

  /**
   * 年度类型
   *
   * */
  @ApiModelProperty(name = "yearType", value = "年度类型 1 自然年 2 企业财年 数据字典 year_type", required = true)
  private String yearType;

  /**
   * 到期提醒
   */
  @ApiModelProperty(name = "expirationReminder", value = "到期提醒 '0' 否 '1' 是 数据字典 expiration_reminder", required = true)
  private String expirationReminder;

  /**
   * 到期提醒天数
   */
  @ApiModelProperty(name = "expirationReminderNum", value = "到期提醒天数", required = true)
  private Integer expirationReminderNum;

  /**
   * 合同到期提示
   */
  @ApiModelProperty(name = "context", value = "合同到期提示", required = true)
  private String context;

  /**
   * 组织名称
   */
  @ApiModelProperty(name = "orgName", value = "组织名称", required = true)
  private String orgName;

  /**
   * 组织编码
   */
  @ApiModelProperty(name = "orgCode", value = "组织编码", required = true)
  private String orgCode;

  /**
   * 首页是否弹出
   */
  @ApiModelProperty("首页是否弹出")
  @Column(name = "index_popup", columnDefinition = "int(1) COMMENT '首页是否弹出,1是0否'")
  private Boolean indexPopup;

  /**
   * 弹出类型(readNotPopup:已阅读后不弹出,everyLoginPopup:每次登陆都弹出)
   */
  @ApiModelProperty("弹出类型(readNotPopup:已阅读后不弹出,everyLoginPopup:每次登陆都弹出)")
  @Column(name = "popup_type", length = 30, columnDefinition = "VARCHAR(30) COMMENT '弹出类型(readNotPopup:已阅读后不弹出,everyLoginPopup:每次登陆都弹出)'")
  private String popupType;

  /**
   * 有效天数
   */
  @ApiModelProperty("有效天数")
  @Column(name = "effective_day", columnDefinition = "int(5) COMMENT '有效天数'")
  private Integer effectiveDay;

  /**
   * 合同元组列表
   */
  @ApiModelProperty(value = "合同要素模型列表")
  private List<ContractTemplateElementDto> templateElements;

}
