package com.biz.crm.dms.business.contract.sdk.enums;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

/**
 * @description: 合同签署方式
 * @author: rentao
 * @date: 2021/12/17 15:44
 */
public enum ContractSignType {

  /**
   * 电子合同签署
   * */
  ELECTRONIC_SIGNATURE("1", "1","电子合同签署","1"),

  /**
   * 短信验证签署
   * */
  MESSAGE_SIGNATURE("2", "2","短信验证签署","2"),

  /**
   * 线上签署
   * */
  ONLINE_SIGNATURE("3", "3","线上签署","3"),
  ;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  ContractSignType(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 ContractSignType
   *
   * @param key
   * @return
   */
  public static ContractSignType getByKey(String key) {
    return Arrays.stream(ContractSignType.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }
}
