package com.biz.crm.dms.business.contract.sdk.enums;

import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

/**
 * @description: 合同年度
 * @author: rentao
 * @date: 2021/12/17 15:43
 */
public enum ContractYearType {

  /**
   * 自然年
   */
  CIVIL_YEAR("1", "1", "自然年", "1"),

  /**
   * 企业财年
   */
  ENTERPRISE_FISCAL_YEAR("2", "2", "企业财年", "2"),
  ;

  private String key;

  /**
   * 字典编码
   */
  private String dictCode;

  /**
   * 字典值
   */
  private String value;

  /**
   * 字典排序
   */
  private String order;

  ContractYearType(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 ContractYearType
   *
   * @param key
   * @return
   */
  public static ContractYearType getByKey(String key) {
    return Arrays.stream(ContractYearType.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }
}
