package com.biz.crm.dms.business.contract.sdk.event.contracttemplate;

import com.biz.crm.dms.business.contract.sdk.vo.contracttemplate.ContractTemplateVo;

import java.util.List;

/**
 * @description: 合同模板信息变更事件通知接口
 * @author: rentao
 * @date: 2021/11/16 14:44
 */
public interface ContractTemplateEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(ContractTemplateVo vo) {
    //通知
  }

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(ContractTemplateVo oldVo, ContractTemplateVo newVo) {
  }

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<ContractTemplateVo> list) {
  }

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<ContractTemplateVo> list) {
  }

  /**
   * 删除是触发
   * @param voList
   */
  void onDelete(List<ContractTemplateVo> voList);
}
