package com.biz.crm.dms.business.contract.sdk.register.contractelement;


import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractVo;
import com.biz.crm.dms.business.contract.sdk.vo.contractelementdata.ContractElementDataVo;


/**
 * @description: 合同要素注册器(需要添加合同要素必须实现此接口)
 * @author: rentao
 * @date: 2021/11/15 23:12
 */
public interface ContractElementRegister<T extends ContractElementDataVo> {

  /**
   * 查询合同要素名称
   */
  String getContractElementName();

  /**
   * 查询合同要素备注
   * */
  default String getContractElementRemarks(){
    return null;
  }

  /**
   * 查询合同要素编码
   */
  String getContractElementCode();

  /**
   * 查询合同组件名称
   * */
  String getContractElementComponentName();

  /**
   * 拿到要素排序列表排序
   */
  Integer getElementSort();

  /**
   * 查询要素bean
   */
  Class<T> getContractElementClass();

  /**
   * 合同编码查询查询合同要素内容
   *
   * @param contractcode
   */
  T getByContractCode(String contractcode);

  /**
   * 保存对应合同要素内容
   *
   * @param contractCode 合同编码
   * @param indexCode
   * @return
   */
  T onRequestContractCreate(String contractCode, T t, Integer indexCode);

  /**
   * 编辑对应合同要素内容
   *
   * @param contractCode 合同编码
   * @param indexCode
   * @return
   */
  T onRequestContractUpdate(String contractCode,T t, Integer indexCode);


  /**
   * 通过合同基本信息命中合同要素内容
   *
   * @param contractVo 合同编码
   * @return
   */
  default T onRequestContractElement(ContractVo contractVo){return null;}
}
