package com.biz.crm.dms.business.contract.sdk.vo.contractelementdata;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;


/**
 * 合同运费要素数据Vo
 *
 * @author ning.zhang
 * @date 2022/8/15
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "合同运费要素数据Vo")
public class ContractFreightDataVo extends ContractElementDataVo {

  /**
   * 合同编码
   */
  @ApiModelProperty(value = "合同编码")
  private String contractCode;

  /**
   * 配送方式
   */
  @ApiModelProperty("配送方式")
  private String distributionType;

  /**
   * 结算方式
   */
  @ApiModelProperty("结算方式")
  private String settlementType;

  /**
   * 运费金额
   */
  @ApiModelProperty("运费金额")
  private BigDecimal freightAmount;

}
