package com.biz.crm.dms.business.contract.sdk.vo.contracttemplate;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.dms.business.contract.sdk.vo.contracttemplateelement.ContractTemplateElementVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * @description: 合同模板vo
 * @author: rentao
 * @date: 2021/11/16 11:31
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "合同模板vo")
public class ContractTemplateVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 5711197545706458946L;

  /**
   * 编码
   */
  @ApiModelProperty(name = "templateCode", value = "合同模板编码", required = true)
  private String templateCode;

  /**
   * 名称
   */
  @ApiModelProperty(name = "templateName", value = "合同模板名称", required = true)
  private String templateName;

  /**
   * 合同签署方式
   * */
  @ApiModelProperty(name = "contractSignType", value = "合同签署方式 '1'电子合同签署 '2'短信验证签署 '3' 线上签署", required = true)
  private String  contractSignType;

  /**
   * 年度类型
   *
   * */
  @ApiModelProperty(name = "yearType", value = "年度类型 1 自然年 2 企业财年", required = true)
  private String yearType;

  /**
   * 到期提醒
   */
  @ApiModelProperty(name = "expirationReminder", value = "到期提醒 '0' 否 '1' 是 ", required = true)
  private String expirationReminder;

  /**
   * 到期提醒天数
   */
  @ApiModelProperty(name = "expirationReminderNum", value = "到期提醒天数", required = true)
  private Integer expirationReminderNum;

  /**
   * 合同到期提示
   */
  @ApiModelProperty(name = "context", value = "合同到期提示")
  private String context;

  /**
   * 组织名称
   */
  @ApiModelProperty(name = "orgName", value = "组织名称", required = true)
  private String orgName;

  /**
   * 组织编码
   */
  @ApiModelProperty(name = "orgCode", value = "组织编码", required = true)
  private String orgCode;

  /**
   * 首页是否弹出
   */
  @ApiModelProperty("首页是否弹出")
  private Boolean indexPopup;

  /**
   * 弹出类型(readNotPopup:已阅读后不弹出,everyLoginPopup:每次登陆都弹出)
   */
  @ApiModelProperty("弹出类型(readNotPopup:已阅读后不弹出,everyLoginPopup:每次登陆都弹出)")
  private String popupType;

  /**
   * 有效天数
   */
  @ApiModelProperty("有效天数")
  private Integer effectiveDay;


  /**
   * 合同元组列表
   */
  @ApiModelProperty(value = "合同要素模型列表")
  private List<ContractTemplateElementVo> templateElements;
}
