/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.capital.local.service.internal;

import com.biz.crm.dms.business.costpool.capital.local.entity.CapitalFlowFile;
import com.biz.crm.dms.business.costpool.capital.local.repository.CapitalFlowFileRepository;
import com.biz.crm.dms.business.costpool.capital.local.service.CapitalFlowFileService;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalFlowFileDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CapitalFlowFileServiceImpl
implements CapitalFlowFileService {
    private static final Logger log = LoggerFactory.getLogger(CapitalFlowFileServiceImpl.class);
    @Autowired(required=false)
    private CapitalFlowFileRepository capitalFlowFileRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public void createBatch(List<CapitalFlowFileDto> capitalFlowFileDtos, String flowNo, String capitalCode) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(capitalFlowFileDtos), (String)"\u8d44\u91d1\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)flowNo, (String)"\u8d44\u91d1\u6d41\u6c34\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List capitalFlowFiles = (List)this.nebulaToolkitService.copyCollectionByWhiteList(capitalFlowFileDtos, CapitalFlowFileDto.class, CapitalFlowFile.class, HashSet.class, ArrayList.class, new String[0]);
        capitalFlowFiles.forEach(s -> {
            s.setFlowNo(flowNo);
            s.setCapitalCode(capitalCode);
        });
        this.capitalFlowFileRepository.saveBatch(capitalFlowFiles);
    }
}

