/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.capital.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.dms.business.costpool.capital.local.entity.CapitalFlow;
import com.biz.crm.dms.business.costpool.capital.local.repository.CapitalFlowRepository;
import com.biz.crm.dms.business.costpool.capital.local.service.CapitalFlowFileService;
import com.biz.crm.dms.business.costpool.capital.local.service.CapitalFlowService;
import com.biz.crm.dms.business.costpool.capital.local.utils.CapitalFlowUtil;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalFlowDto;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.CapitalAdjustTypeEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CapitalFlowServiceImpl
implements CapitalFlowService {
    private static final Logger log = LoggerFactory.getLogger(CapitalFlowServiceImpl.class);
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private CapitalFlowFileService capitalFlowFileService;
    @Autowired(required=false)
    private CapitalFlowRepository capitalFlowRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<CapitalFlow> findByConditions(Pageable pageable, CapitalFlowDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new CapitalFlowDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.capitalFlowRepository.findByConditions((Page<CapitalFlow>)page, dto);
    }

    @Override
    public List<CapitalFlow> findByCapitalCode(CapitalFlowDto capitalFlowDto) {
        Validate.notNull((Object)capitalFlowDto, (String)"\u8d44\u91d1\u4fe1\u606f\u4f20\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)capitalFlowDto.getCapitalCode(), (String)"\u8d44\u91d1\u7f16\u7801\u5fc5\u4f20", (Object[])new Object[0]);
        return this.capitalFlowRepository.findByCapitalFlowDto(capitalFlowDto);
    }

    @Override
    @Transactional
    public CapitalFlow create(CapitalFlowDto capitalFlowDto) {
        CapitalFlowUtil.validateAdd(capitalFlowDto);
        capitalFlowDto.setFlowNo((String)this.generateCodeService.generateCode("KHLS", 1).get(0));
        CapitalAdjustTypeEnum adjustTypeEnum = CapitalAdjustTypeEnum.getByKey((String)capitalFlowDto.getAdjustType());
        Validate.notNull((Object)adjustTypeEnum, (String)"\u4f20\u5165\u7c7b\u578b\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        CapitalFlow entity = (CapitalFlow)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)capitalFlowDto, CapitalFlow.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setId(null);
        entity.setCreateTime(new Date());
        this.capitalFlowRepository.save((Object)entity);
        if (CollectionUtils.isNotEmpty((Collection)capitalFlowDto.getCapitalFlowFileDtos())) {
            this.capitalFlowFileService.createBatch(capitalFlowDto.getCapitalFlowFileDtos(), capitalFlowDto.getFlowNo(), capitalFlowDto.getCapitalCode());
        }
        return entity;
    }
}

