/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.capital.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.dms.business.costpool.capital.local.entity.Capital;
import com.biz.crm.dms.business.costpool.capital.local.repository.CapitalRepository;
import com.biz.crm.dms.business.costpool.capital.local.service.CapitalFlowService;
import com.biz.crm.dms.business.costpool.capital.local.service.CapitalService;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalDto;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalFlowDto;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalPageDto;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CostPoolCapitalDto;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.CapitalAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.capital.sdk.strategy.CapitalOperationTypeStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CapitalServiceImpl
implements CapitalService {
    private static final Logger log = LoggerFactory.getLogger(CapitalServiceImpl.class);
    @Autowired(required=false)
    private CapitalRepository capitalRepository;
    @Autowired(required=false)
    private CapitalFlowService capitalFlowService;
    @Autowired(required=false)
    private List<CapitalOperationTypeStrategy> capitalOperationTypeStrategys;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public Capital create(CapitalDto capitalDto) {
        this.validateAdd(capitalDto);
        Capital entity = (Capital)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)capitalDto, Capital.class, HashSet.class, ArrayList.class, new String[0]));
        this.capitalRepository.saveOrUpdate((Object)entity);
        CapitalFlowDto capitalFlowDto = (CapitalFlowDto)this.nebulaToolkitService.copyObjectByBlankList((Object)capitalDto, CapitalFlowDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.capitalFlowService.create(capitalFlowDto);
        return entity;
    }

    @Override
    @Transactional
    public void handleAdjust(CostPoolCapitalDto costPoolCapitalDto) {
        this.handleAdjustValidate(costPoolCapitalDto);
        CapitalAdjustTypeEnum operationTypeEnum = CapitalAdjustTypeEnum.getByKey((String)costPoolCapitalDto.getAdjustType());
        Validate.notNull((Object)operationTypeEnum, (String)"\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c\u7c7b\u578b\u8fdb\u884c\u8c03\u6574\u8d39\u7528\u6c60\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(this.capitalOperationTypeStrategys) ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u64cd\u4f5c\u7c7b\u578b\u5bf9\u5e94\u7684\u7b56\u7565\u5b9e\u73b0", (Object[])new Object[0]);
        for (CapitalOperationTypeStrategy operationTypeStrategy : this.capitalOperationTypeStrategys) {
            String group = operationTypeStrategy.getOperationTypeGroup();
            if (!StringUtils.equals((CharSequence)group, (CharSequence)costPoolCapitalDto.getAdjustType())) continue;
            operationTypeStrategy.onSaveCapitalInfos(costPoolCapitalDto);
            break;
        }
    }

    @Override
    public Page<Capital> findByConditions(Pageable pageable, CapitalPageDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new CapitalPageDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.capitalRepository.findByConditions((Page<Capital>)page, dto);
    }

    @Override
    public Capital findById(String id) {
        Validate.notNull((Object)id, (String)"\u4f20\u5165id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return (Capital)((Object)this.capitalRepository.getById((Serializable)((Object)id)));
    }

    @Override
    public Capital findByCustomerCode(String customerCode) {
        Validate.notNull((Object)customerCode, (String)"\u4f20\u5165\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.capitalRepository.findByCusCode(customerCode);
    }

    private void handleAdjustValidate(CostPoolCapitalDto costPoolCapitalDto) {
        Validate.notNull((Object)costPoolCapitalDto, (String)"\u8c03\u6574\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolCapitalDto.getCustomerCode(), (String)"\u8c03\u6574\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costPoolCapitalDto.getAdjustType(), (String)"\u8c03\u6574\u65f6\uff0c\u8c03\u6574\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolCapitalDto.getAdjustMoney(), (String)"\u8c03\u6574\u65f6\uff0c\u8c03\u6574\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void validateAdd(CapitalDto capitalDto) {
        Validate.notNull((Object)capitalDto, (String)"\u8d44\u91d1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)capitalDto.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)capitalDto.getCustomerName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)capitalDto.getCapitalTotal(), (String)"\u8d44\u91d1\u8d26\u6b3e\u603b\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)capitalDto.getFrozeMoney(), (String)"\u8d44\u91d1\u51bb\u7ed3\u603b\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)capitalDto.getCapitalAbleTotal(), (String)"\u8d44\u91d1\u53ef\u7528\u4f59\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((capitalDto.getCapitalAbleTotal().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u8d44\u91d1\u53ef\u7528\u4f59\u989d\u4e0d\u80fd\u5c0f\u4e8e\u96f6", (Object[])new Object[0]);
        Validate.isTrue((capitalDto.getCapitalTotal().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u8d44\u91d1\u8d26\u6b3e\u603b\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u96f6", (Object[])new Object[0]);
        Validate.isTrue((capitalDto.getFrozeMoney().compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"\u8d44\u91d1\u51bb\u7ed3\u603b\u989d\u4e0d\u80fd\u5c0f\u4e8e\u96f6", (Object[])new Object[0]);
    }
}

