/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.capital.local.service.observer;

import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalFlowCustomerDto;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.CapitalAdjustGroupEnum;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.CapitalAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.PoolTypeEnum;
import com.biz.crm.dms.business.costpool.capital.sdk.service.CapitalFlowVoService;
import com.biz.crm.dms.business.costpool.capital.sdk.vo.CapitalFlowVo;
import com.biz.crm.dms.business.costpool.sdk.enums.CostPoolSummaryEnum;
import com.biz.crm.dms.business.costpool.sdk.observer.CostPoolAmountStatisticsObserver;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolAmountStatisticsVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CostPoolAmountStatisticsCapitalImpl
implements CostPoolAmountStatisticsObserver {
    private static final Logger log = LoggerFactory.getLogger(CostPoolAmountStatisticsCapitalImpl.class);
    @Autowired(required=false)
    private CapitalFlowVoService capitalFlowVoService;

    public List<CostPoolAmountStatisticsVo> findAmountStatisticsVoByCustomerCodeAndDate(String customerCode, Date beginDate, Date endDate) {
        Validate.notBlank((CharSequence)customerCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.notNull((Object)beginDate, (String)"\u8bf7\u8f93\u5165\u5bf9\u8d26\u5f00\u59cb\u65f6\u95f4", (Object[])new Object[0]);
        Validate.notNull((Object)endDate, (String)"\u8bf7\u8f93\u5165\u5bf9\u8d26\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        ArrayList<CostPoolAmountStatisticsVo> list = new ArrayList<CostPoolAmountStatisticsVo>();
        BigDecimal startCount = this.startCount(customerCode, beginDate, endDate);
        BigDecimal endCount = this.endCount(customerCode, beginDate, endDate);
        CapitalFlowCustomerDto capitalFlowCustomerDto = new CapitalFlowCustomerDto();
        capitalFlowCustomerDto.setCustomerCode(customerCode);
        capitalFlowCustomerDto.setEndTime(endDate);
        capitalFlowCustomerDto.setStartTime(beginDate);
        List capitalFlowVos = this.capitalFlowVoService.findByCapitalFlowCustomerDto(capitalFlowCustomerDto);
        for (CostPoolSummaryEnum costPoolSummaryEnum : CostPoolSummaryEnum.values()) {
            BigDecimal decimal;
            CostPoolAmountStatisticsVo costPoolAmountStatisticsVo = new CostPoolAmountStatisticsVo();
            costPoolAmountStatisticsVo.setPoolType(PoolTypeEnum.CAPITAL.getKey());
            costPoolAmountStatisticsVo.setSummary(costPoolSummaryEnum.getKey());
            if (CostPoolSummaryEnum.OCCUPY.getKey().equals(costPoolSummaryEnum.getKey())) {
                decimal = capitalFlowVos.stream().filter(f -> CapitalAdjustTypeEnum.OCCUPY_USE.getKey().equals(f.getAdjustType()) || CapitalAdjustTypeEnum.OCCUPY_RELEASE.getKey().equals(f.getAdjustType())).map(CapitalFlowVo::getAdjustMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
                costPoolAmountStatisticsVo.setTotalAmount(decimal);
            } else {
                decimal = this.countAmount(capitalFlowVos, costPoolSummaryEnum);
                costPoolAmountStatisticsVo.setTotalAmount(decimal);
                if (costPoolSummaryEnum.getKey().equals(CostPoolSummaryEnum.BEGIN.getKey())) {
                    costPoolAmountStatisticsVo.setTotalAmount(startCount);
                }
                if (costPoolSummaryEnum.getKey().equals(CostPoolSummaryEnum.END.getKey())) {
                    if (endCount == null) {
                        costPoolAmountStatisticsVo.setTotalAmount(startCount);
                    } else {
                        costPoolAmountStatisticsVo.setTotalAmount(endCount);
                    }
                }
            }
            list.add(costPoolAmountStatisticsVo);
        }
        return list;
    }

    private BigDecimal countAmount(List<CapitalFlowVo> capitalFlowVos, CostPoolSummaryEnum costPoolSummaryEnum) {
        if (CollectionUtils.isEmpty(capitalFlowVos)) {
            return BigDecimal.ZERO;
        }
        ArrayList list = new ArrayList();
        if (costPoolSummaryEnum.getKey().equals(CostPoolSummaryEnum.ON.getKey())) {
            list.addAll(CapitalAdjustTypeEnum.getDictCodeByGroupEnum((CapitalAdjustGroupEnum)CapitalAdjustGroupEnum.ON));
        }
        if (costPoolSummaryEnum.getKey().equals(CostPoolSummaryEnum.USE.getKey())) {
            list.addAll(CapitalAdjustTypeEnum.getDictCodeByGroupEnum((CapitalAdjustGroupEnum)CapitalAdjustGroupEnum.USE));
        }
        List capitalFlows = capitalFlowVos.stream().filter(capitalFlowVo -> list.contains(capitalFlowVo.getAdjustType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(capitalFlowVos)) {
            return BigDecimal.ZERO;
        }
        BigDecimal count = BigDecimal.ZERO;
        for (CapitalFlowVo capitalFlow : capitalFlows) {
            if (capitalFlow.getAdjustType().equals(CapitalAdjustTypeEnum.FREEZE_UNFREEZE.getKey())) {
                count = count.subtract(capitalFlow.getAdjustMoney());
                continue;
            }
            count = count.add(capitalFlow.getAdjustMoney());
        }
        return count;
    }

    private BigDecimal startCount(String customerCode, Date beginDate, Date endDate) {
        CapitalFlowCustomerDto capitalDto = new CapitalFlowCustomerDto();
        capitalDto.setCustomerCode(customerCode);
        capitalDto.setEndTime(beginDate);
        capitalDto.setStartTime(null);
        List capitalList = this.capitalFlowVoService.findByCapitalFlowCustomerDto(capitalDto);
        if (!CollectionUtils.isEmpty((Collection)capitalList)) {
            CapitalFlowVo capital = (CapitalFlowVo)capitalList.get(0);
            return capital.getCapitalAbleTotal();
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal endCount(String customerCode, Date beginDate, Date endDate) {
        CapitalFlowCustomerDto capitalDto = new CapitalFlowCustomerDto();
        capitalDto.setStartTime(beginDate);
        capitalDto.setEndTime(endDate);
        capitalDto.setCustomerCode(customerCode);
        List capitalList = this.capitalFlowVoService.findByCapitalFlowCustomerDto(capitalDto);
        if (!CollectionUtils.isEmpty((Collection)capitalList)) {
            CapitalFlowVo capitalFlowVo = (CapitalFlowVo)capitalList.get(0);
            return capitalFlowVo.getCapitalAbleTotal();
        }
        return null;
    }
}

