/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.costpool.capital.local.service.observer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.dms.business.costpool.capital.local.entity.Capital;
import com.biz.crm.dms.business.costpool.capital.local.service.CapitalService;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CostPoolCapitalDto;
import com.biz.crm.dms.business.costpool.capital.sdk.vo.CapitalCostPoolVo;
import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolRegister;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolStrategy;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolVo;
import com.bizunited.nebula.common.util.JsonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class CostPoolCapitalStrategyImpl
implements CostPoolStrategy {
    @Autowired(required=false)
    @Qualifier(value="costPoolCapitalRegisterImpl")
    private CostPoolRegister costPoolRegister;
    @Autowired(required=false)
    private CapitalService capitalService;

    public String getPoolTypeRegisterKey() {
        return this.costPoolRegister.getKey();
    }

    public List<CostPoolVo> onRequestCostPoolVos(CostPoolDto costPoolDto) {
        if (Objects.isNull(costPoolDto)) {
            return null;
        }
        if (!StringUtils.equals((CharSequence)costPoolDto.getPoolType(), (CharSequence)this.costPoolRegister.getKey())) {
            return null;
        }
        Capital capital = this.capitalService.findByCustomerCode(costPoolDto.getCustomerCode());
        if (Objects.isNull((Object)capital)) {
            return new ArrayList<CostPoolVo>(0);
        }
        CapitalCostPoolVo costPoolVo = new CapitalCostPoolVo();
        costPoolVo.setPoolCode(capital.getCapitalCode());
        costPoolVo.setCustomerCode(capital.getCustomerCode());
        costPoolVo.setCustomerName(capital.getCustomerName());
        costPoolVo.setTotalAmount(capital.getCapitalTotal());
        costPoolVo.setFreezeAmount(capital.getFrozeMoney());
        costPoolVo.setUsableAmount(capital.getCapitalAbleTotal());
        return Collections.singletonList(costPoolVo);
    }

    public void onHandleAdjust(JSONObject jsonObject) {
        Validate.notNull((Object)jsonObject, (String)"\u5ba2\u6237\u8d44\u91d1\u6c60\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CostPoolCapitalDto costPoolCapitalDto = (CostPoolCapitalDto)JsonUtils.json2Obj((String)jsonObject.toJSONString(), CostPoolCapitalDto.class);
        Validate.notBlank((CharSequence)costPoolCapitalDto.getPoolType(), (String)"\u8c03\u6574\u65f6\uff0c\u8d39\u7528\u6c60\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolCapitalDto.getAdjustType(), (String)"\u5ba2\u6237\u8d44\u91d1\u8c03\u6574\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)costPoolCapitalDto.getAmount(), (String)"\u8c03\u6574\u65f6\uff0c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        costPoolCapitalDto.setAdjustMoney(costPoolCapitalDto.getAmount());
        this.capitalService.handleAdjust(costPoolCapitalDto);
    }
}

