package com.biz.crm.dms.business.costpool.capital.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.capital.local.entity.CapitalFlow;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalAdjustQueryDto;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalFlowDto;
import com.biz.crm.dms.business.costpool.capital.sdk.service.CapitalAdjustTypeVoService;
import com.biz.crm.dms.business.costpool.capital.sdk.vo.CapitalAdjustTypeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 资金调整类型
 * @author: rentao
 * @date: 2022/3/17 11:09
 */
@Slf4j
@Api(tags = "资金调整类型: CapitalAdjustType : 资金调整类型")
@RestController
@RequestMapping(value = {"/v1/capitalAdjustType/capitalAdjustType"})
public class CapitalAdjustTypeVoController {

  @Autowired(required = false)
  private CapitalAdjustTypeVoService capitalAdjustTypeVoService;

  /**
   * 资金编码查询资金流水
   *
   * @param capitalAdjustQueryDto
   */
  @ApiOperation(value = "资金调整类型集合查询")
  @GetMapping("/findCapitalAdjustTypeVo")
  public Result<List<CapitalAdjustTypeVo>> findCapitalAdjustTypeVo(
      CapitalAdjustQueryDto capitalAdjustQueryDto) {
    return Result.ok(this.capitalAdjustTypeVoService.findCapitalAdjustTypeVo(capitalAdjustQueryDto));
  }
}
