package com.biz.crm.dms.business.costpool.capital.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.capital.local.constant.CapitalConstant;
import com.biz.crm.dms.business.costpool.capital.local.entity.Capital;
import com.biz.crm.dms.business.costpool.capital.local.service.CapitalService;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalDto;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalPageDto;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CostPoolCapitalDto;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.concurrent.TimeUnit;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

/**
 * @description: 资金管理: Capital 资金信息
 * @author: rentao
 * @date: 2021/12/13 20:02
 */
@Slf4j
@Api(tags = "资金管理: Capital : 资金信息")
@RestController
@RequestMapping(value = {"/v1/capital/capital"})
public class CapitalController {

  @Autowired(required = false) private CapitalService capitalService;

  @Autowired(required = false) private RedisMutexService redisMutexService;

  /**
   * 分页查询
   *
   * @param pageable
   * @param capitalDto
   */
  @ApiOperation(value = "分页查询")
  @GetMapping("/findByConditions")
  public Result<Page<Capital>> findByConditions(
      @PageableDefault(50) Pageable pageable, CapitalPageDto capitalDto) {
    return Result.ok(this.capitalService.findByConditions(pageable, capitalDto));
  }


  /**
   * 根据主键id查询
   *
   * @param id
   */
  @ApiOperation(value = "根据主键id查询")
  @GetMapping("/findById")
  public Result<Capital> findById(@RequestParam String id) {
    return Result.ok(this.capitalService.findById(id));
  }

  /**
   * 客户资金池调整
   *
   * @param costPoolCapitalDto
   */
  @ApiOperation(value = "客户资金池调整")
  @PatchMapping("handleAdjust")
  public Result<?> handleAdjust(
      @RequestBody CostPoolCapitalDto costPoolCapitalDto) {
    String lockKey =
        String.format(CapitalConstant.CAPITAL_CHANGE_LOCK_KEY, TenantUtils.getTenantCode());
    Validate.isTrue(
        this.redisMutexService.tryLock(
            lockKey, TimeUnit.SECONDS, CapitalConstant.CAPITAL_TRY_LOCK_OUT_TIME),
        CapitalConstant.CAPITAL_LOCK_FAIL_MESSAGE);
    try {
      this.capitalService.handleAdjust(costPoolCapitalDto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    } finally {
      this.redisMutexService.unlock(lockKey);
    }
  }

}
