package com.biz.crm.dms.business.costpool.capital.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.capital.local.entity.CapitalFlow;
import com.biz.crm.dms.business.costpool.capital.local.service.CapitalFlowService;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalFlowDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @description: 资金流水管理: CapitalFlow 资金流水
 * @author: rentao
 * @date: 2021/12/13 20:02
 */
@Slf4j
@Api(tags = "资金流水管理: CapitalFlow : 资金流水")
@RestController
@RequestMapping(value = {"/v1/capitalFlow/capitalFlow"})
public class CapitalFlowController {

  @Autowired(required = false) private CapitalFlowService capitalFlowService;

  /**
   * 分页查询
   *
   * @param pageable
   * @param capitalFlowDto
   */
  @ApiOperation(value = "分页查询")
  @GetMapping("/findByConditions")
  public Result<Page<CapitalFlow>> findByConditions(
      @PageableDefault(50) Pageable pageable, CapitalFlowDto capitalFlowDto) {
    return Result.ok(this.capitalFlowService.findByConditions(pageable, capitalFlowDto));
  }

  /**
   * 资金编码查询资金流水
   *
   * @param capitalFlowDto
   */
  @ApiOperation(value = "资金编码查询资金流水")
  @GetMapping("/findByCapitalCode")
  public Result<List<CapitalFlow>> findByCapitalCode(CapitalFlowDto capitalFlowDto) {
    return Result.ok(this.capitalFlowService.findByCapitalCode(capitalFlowDto));
  }
}
