package com.biz.crm.dms.business.costpool.capital.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.costpool.capital.local.entity.CapitalFlow;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalFlowCustomerDto;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalFlowDto;
import com.biz.crm.dms.business.costpool.capital.sdk.service.CapitalFlowVoService;
import com.biz.crm.dms.business.costpool.capital.sdk.vo.CapitalFlowVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 资金流水管理: CapitalFlow 资金流水
 * @author: rentao
 * @date: 2021/12/13 20:02
 */
@Slf4j
@Api(tags = "资金流水管理: CapitalFlowVo : 资金流水vo")
@RestController
@RequestMapping(value = {"/v1/capitalFlow/capitalFlow"})
public class CapitalFlowVoController {

  @Autowired(required = false) private CapitalFlowVoService capitalFlowVoService;

  /**
   * 根据主键id查询
   *
   * @param id
   */
  @ApiOperation(value = "根据主键id查询")
  @GetMapping("/findById")
  public Result<CapitalFlowVo> findById(@RequestParam String id) {
    CapitalFlowVo result = this.capitalFlowVoService.findById(id);
    return Result.ok(result);
  }

  /**
   * 根据流水编码查询
   *
   * @param flowNo
   */
  @ApiOperation(value = "根据流水编码查询")
  @GetMapping("/findByFlowNo")
  public Result<CapitalFlowVo> findByFlowNo(@RequestParam String flowNo) {
    CapitalFlowVo result = this.capitalFlowVoService.findDetailsByFlowNo(flowNo);
    return Result.ok(result);
  }

  /**
   * 客户-资金明细分页查询
   *
   * @param pageable
   * @param capitalFlowCustomerDto
   */
  @ApiOperation(value = "客户-资金明细分页查询")
  @GetMapping("/findByCapitalFlowCustomerDto")
  public Result<Page<CapitalFlowVo>> findByCapitalFlowCustomerDto(
      @PageableDefault(50) Pageable pageable, CapitalFlowCustomerDto capitalFlowCustomerDto) {
    return Result.ok(this.capitalFlowVoService.findByCapitalFlowCustomerDto(pageable, capitalFlowCustomerDto));
  }
}
