package com.biz.crm.dms.business.costpool.capital.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @description: 客户资金管理
 * @author: rentao
 * @date: 2021/12/13 19:31
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CapitalEntity", description = "客户资金")
@Entity
@TableName("dms_capital")
@Table(name = "dms_capital")
@org.hibernate.annotations.Table(appliesTo = "dms_capital", comment = "客户资金")
public class Capital extends TenantFlagOpEntity {

  private static final long serialVersionUID = -2907621585607605964L;

  /** 资金池编码 */
  @ApiModelProperty(name = "capitalCode", value = "资金池编码", required = true)
  @Column(
      name = "capital_code",
      length = 128,
      columnDefinition = "VARCHAR(128) NOT NULL COMMENT '资金池编码'")
  private String capitalCode;

  /** 客户编码 */
  @ApiModelProperty(name = "customerCode", value = "客户编码", required = true)
  @Column(
      name = "customer_code",
      length = 128,
      columnDefinition = "VARCHAR(128) NOT NULL COMMENT '客户编码'")
  private String customerCode;

  /** 客户名称 */
  @ApiModelProperty(name = "customerName", value = "客户名称", required = true)
  @Column(
      name = "customer_name",
      length = 128,
      columnDefinition = "VARCHAR(128) NOT NULL COMMENT '客户名称'")
  private String customerName;

  /** 客户组织编码 */
  @ApiModelProperty(name = "cusOrgCode", value = "客户组织编码", required = true)
  @Column(
      name = "cus_org_code",
      length = 128,
      columnDefinition = "VARCHAR(128) COMMENT '客户组织编码'")
  private String cusOrgCode;

  /** 客户组织名称 */
  @ApiModelProperty(name = "cusOrgName", value = "客户组织名称", required = true)
  @Column(
      name = "cus_org_name",
      length = 128,
      columnDefinition = "VARCHAR(128) COMMENT '客户组织名称'")
  private String cusOrgName;

  /** 客户所属公司编码 */
  @ApiModelProperty(name = "companyCode", value = "客户所属公司编码", required = true)
  @Column(
      name = "company_code",
      length = 128,
      columnDefinition = "VARCHAR(128)  COMMENT '客户所属公司编码'")
  private String companyCode;

  /** 客户所属公司名称 */
  @ApiModelProperty(name = "companyName", value = "客户所属公司名称", required = true)
  @Column(
      name = "company_name",
      length = 128,
      columnDefinition = "VARCHAR(128)  COMMENT '客户所属公司名称'")
  private String companyName;

  /** 账款总金额 */
  @ApiModelProperty(name = "capitalSurplusTotal", value = "账款总金额", required = true)
  @Column(name = "capital_total", columnDefinition = "decimal(20,4) COMMENT '账款总金额'")
  private BigDecimal capitalTotal;

  /** 资金可用余额 */
  @ApiModelProperty(name = "capitalAbleTotal", value = "资金可用余额", required = true)
  @Column(name = "capital_able_total", columnDefinition = "decimal(20,4) COMMENT '资金可用余额'")
  private BigDecimal capitalAbleTotal;

  /** 冻结总额 */
  @ApiModelProperty(name = "frozeMoney", value = "冻结总额", required = true)
  @Column(name = "froze_money", columnDefinition = "decimal(20,4) COMMENT '冻结总额'")
  private BigDecimal frozeMoney;

  /** 占用总额 */
  @ApiModelProperty(name = "occupyMoney", value = "占用总额", required = true)
  @Column(name = "occupy_money", columnDefinition = "decimal(20,4) COMMENT '占用总额'")
  private BigDecimal occupyMoney;

  /** 已使用总额 */
  @ApiModelProperty(name = "useMoney", value = "已使用总额", required = true)
  @Column(name = "use_money", columnDefinition = "decimal(20,4) COMMENT '已使用总额'")
  private BigDecimal useMoney;
}
