package com.biz.crm.dms.business.costpool.capital.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.persistence.Transient;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @description: 客户资金流水
 * @author: rentao
 * @date: 2021/12/13 19:32
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CapitalFlowEntity", description = "客户资金流水")
@Entity
@TableName("dms_capital_flow")
@Table(name = "dms_capital_flow")
@org.hibernate.annotations.Table(appliesTo = "dms_capital_flow", comment = "客户资金流水")
public class CapitalFlow extends TenantFlagOpEntity {

  private static final long serialVersionUID = -2907621585607605964L;

  /** 资金池编码 */
  @ApiModelProperty(name = "capitalCode", value = "资金池编码", required = true)
  @Column(
      name = "capital_code",
      length = 128,
      columnDefinition = "VARCHAR(128) NOT NULL COMMENT '资金池编码'")
  private String capitalCode;

  /** 流水号 */
  @ApiModelProperty(name = "flowNo", value = "流水号", required = true)
  @Column(name = "flow_no", length = 128, columnDefinition = "VARCHAR(128) NOT NULL COMMENT '流水号'")
  private String flowNo;

  /** 客户编码 */
  @ApiModelProperty(name = "customerCode", value = "客户编码", required = true)
  @Column(
      name = "customer_code",
      length = 128,
      columnDefinition = "VARCHAR(128) NOT NULL COMMENT '客户编码'")
  private String customerCode;

  /** 客户sap编码 */
  @ApiModelProperty(name = "cusSapCode", value = "客户名称", required = true)
  @Column(name = "cus_sap_code", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '客户名称'")
  private String cusSapCode;

  /** 客户名称 */
  @ApiModelProperty(name = "customerName", value = "客户名称", required = true)
  @Column(
      name = "customer_name",
      length = 128,
      columnDefinition = "VARCHAR(128) NOT NULL COMMENT '客户名称'")
  private String customerName;

  /** 客户组织编码 */
  @ApiModelProperty(name = "cusOrgCode", value = "客户组织编码", required = true)
  @Column(
      name = "cus_org_code",
      length = 128,
      columnDefinition = "VARCHAR(128)  COMMENT '客户组织编码'")
  private String cusOrgCode;

  /** 客户组织名称 */
  @ApiModelProperty(name = "cusOrgName", value = "客户组织名称", required = true)
  @Column(
      name = "cus_org_name",
      length = 128,
      columnDefinition = "VARCHAR(128) COMMENT '客户组织名称'")
  private String cusOrgName;

  /** 客户所属公司编码 */
  @ApiModelProperty(name = "companyCode", value = "客户所属公司编码", required = true)
  @Column(
      name = "company_code",
      length = 128,
      columnDefinition = "VARCHAR(128)  COMMENT '客户所属公司编码'")
  private String companyCode;

  /** 客户所属公司名称 */
  @ApiModelProperty(name = "companyName", value = "客户所属公司名称", required = true)
  @Column(
      name = "company_name",
      length = 128,
      columnDefinition = "VARCHAR(128)  COMMENT '客户所属公司名称'")
  private String companyName;

  /** 调整类型（字典） */
  @ApiModelProperty(name = "adjustType", value = "调整类型", required = true)
  @Column(name = "adjust_type", length = 24, columnDefinition = "VARCHAR(24)  COMMENT '调整类型'")
  private String adjustType;

  /** 调整类型（字典） */
  @ApiModelProperty(name = "adjustTypeName", value = "调整类型名称", required = true)
  @Column(name = "adjust_type_name", length = 24, columnDefinition = "VARCHAR(24)  COMMENT '调整类型名称'")
  private String adjustTypeName;

  /** 单据类型（字典） */
  @ApiModelProperty(name = "billType", value = "单据类型", required = true)
  @Column(name = "bill_type", length = 24, columnDefinition = "VARCHAR(24)  COMMENT '单据类型'")
  private String billType;

  /** 单据号 */
  @ApiModelProperty(name = "billNo", value = "单据号", required = true)
  @Column(name = "bill_No", length = 128, columnDefinition = "VARCHAR(128)  COMMENT '单据号'")
  private String billNo;

  /** 操作金额 */
  @ApiModelProperty(name = "adjustMoney", value = "操作金额", required = true)
  @Column(name = "adjust_money", columnDefinition = "decimal(20,4) COMMENT '操作金额'")
  private BigDecimal adjustMoney;

  /** 资金可用余额 */
  @ApiModelProperty(name = "capitalAbleTotal", value = "冻结总额", required = true)
  @Column(name = "capital_able_total", columnDefinition = "decimal(20,4) COMMENT '资金可用余额'")
  private BigDecimal capitalAbleTotal;

  /** 冻结总额 */
  @ApiModelProperty(name = "frozeMoney", value = "冻结总额", required = true)
  @Column(name = "froze_money", columnDefinition = "decimal(20,4) COMMENT '冻结总额'")
  private BigDecimal frozeMoney;

  /** 已使用总额 */
  @ApiModelProperty(name = "useMoney", value = "已使用总额", required = true)
  @Column(name = "use_money", columnDefinition = "decimal(20,4) COMMENT '已使用总额'")
  private BigDecimal useMoney;

  @ApiModelProperty("流水附件")
  @Transient
  @TableField(exist = false)
  private List<CapitalFlowFile> capitalFlowFiles;
}
