package com.biz.crm.dms.business.costpool.capital.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @description: 客户资金流水附件
 * @author: rentao
 * @date: 2021/12/13 19:32
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CapitalFlowFileEntity", description = "客户资金流水附件")
@Entity
@TableName("dms_capital_flow_files")
@Table(name = "dms_capital_flow_files")
@org.hibernate.annotations.Table(appliesTo = "dms_capital_flow_files", comment = "客户资金流水附件")
public class CapitalFlowFile extends UuidFlagOpEntity {

  private static final long serialVersionUID = -2907621585607605964L;

  /** 资金编码 */
  @ApiModelProperty(name = "capitalCode", value = "资金编码", required = true)
  @Column(
      name = "capital_code",
      length = 64,
      columnDefinition = "VARCHAR(64) NOT NULL COMMENT '资金编码'")
  private String capitalCode;

  /** 流水号 */
  @ApiModelProperty(name = "flowNo", value = "流水号", required = true)
  @Column(name = "flow_no", length = 128, columnDefinition = "VARCHAR(128) NOT NULL COMMENT '流水号'")
  private String flowNo;

  /**
   * 文件唯一识别号
   */
  @ApiModelProperty(value = "文件唯一识别号")
  @TableField(value = "file_code")
  @Column(name = "file_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '文件唯一识别号'")
  private String fileCode;

  /**
   * 原始文件名
   */
  @ApiModelProperty(name="originalFileName" , value="原始文件名")
  @TableField(value = "original_name")
  @Column(name = "original_name", nullable = true, columnDefinition = "varchar(255) COMMENT '原始文件名'")
  private String originalFileName;
}
