package com.biz.crm.dms.business.costpool.capital.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.capital.local.entity.CapitalFlow;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalFlowCustomerDto;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalFlowDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @description: 资金流水 的 mybatis-plus接口类
 * @author: rentao
 * @date: 2021/12/13 20:02
 */
public interface CapitalFlowMapper extends BaseMapper<CapitalFlow> {

  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto 分页参数dto
   * @return 分页列表
   */
  Page<CapitalFlow> findByConditions(Page<CapitalFlow> page, @Param("dto") CapitalFlowDto dto);

  /**
   * 资金流水不分页查询 多条件查询
   *
   * @param dto 分页参数dto
   * @return 分页列表
   */
  List<CapitalFlow> findByCapitalFlowDto(@Param("dto") CapitalFlowDto dto);

  /**
   * 客户-资金明细分页查询
   * @param page
   * @param dto 分页参数dto
   * @return
   */
  Page<CapitalFlow> findByCapitalFlowCustomerDto(Page<CapitalFlow> page, @Param("dto") CapitalFlowCustomerDto dto);

  /**
   * 客户-资金明细查询
   * @param dto 参数dto
   * @return
   */
  List<CapitalFlow> findByCapitalFlowCustomerDto(@Param("dto") CapitalFlowCustomerDto dto);
}
