package com.biz.crm.dms.business.costpool.capital.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.dms.business.costpool.capital.local.entity.CapitalFlow;
import com.biz.crm.dms.business.costpool.capital.local.entity.CapitalFlowFile;
import com.biz.crm.dms.business.costpool.capital.local.mapper.CapitalFlowFileMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @description: 资金明细附件 的 数据库访问类 {@link CapitalFlow}
 * @author: rentao
 * @date: 2021/12/13 20:36
 */
@Component
public class CapitalFlowFileRepository extends ServiceImpl<CapitalFlowFileMapper, CapitalFlowFile> {

  /**
   * 通过资金流水查询关联资金附件
   *
   * @param flowNo
   * @author rentao
   * @date
   */
  public List<CapitalFlowFile> findByFlowNo(String flowNo) {
    if (StringUtils.isBlank(flowNo)) {
      return null;
    }
    return this.lambdaQuery()
        .eq(CapitalFlowFile::getFlowNo, flowNo)
        .eq(CapitalFlowFile::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .orderByDesc(CapitalFlowFile::getCreateTime)
        .list();
  }
}
