package com.biz.crm.dms.business.costpool.capital.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.dms.business.costpool.capital.local.entity.CapitalFlow;
import com.biz.crm.dms.business.costpool.capital.local.mapper.CapitalFlowMapper;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalFlowCustomerDto;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalFlowDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @description: 资金明细 的 数据库访问类 {@link CapitalFlow}
 * @author: rentao
 * @date: 2021/11/16 14:00
 */
@Component
public class CapitalFlowRepository extends ServiceImpl<CapitalFlowMapper, CapitalFlow> {

  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<CapitalFlow> findByConditions(Page<CapitalFlow> page, CapitalFlowDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }

  /**
   * 通过客户编码查询 客户资金流水信息 倒叙
   *
   * @param dto
   * @author rentao
   * @date
   */
  public List<CapitalFlow> findByCapitalFlowDto(CapitalFlowDto dto) {
    return this.baseMapper.findByCapitalFlowDto(dto);
  }

  /**
   * 通过资金流水编码查询 客户资金流水信息
   *
   * @param flowNo
   * @author rentao
   * @date
   */
  public CapitalFlow findByFlowNo(String flowNo) {
    if (StringUtils.isBlank(flowNo)) {
      return null;
    }
    return this.lambdaQuery()
        .eq(CapitalFlow::getFlowNo, flowNo)
        .eq(CapitalFlow::getTenantCode, TenantUtils.getTenantCode())
        .eq(CapitalFlow::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .one();
  }

  /**
   * 客户-资金明细分页查询
   * @param page
   * @param capitalFlowCustomerDto
   * @return
   */
  public Page<CapitalFlow> findByCapitalFlowCustomerDto(Page<CapitalFlow> page, CapitalFlowCustomerDto capitalFlowCustomerDto) {
    return this.baseMapper.findByCapitalFlowCustomerDto(page, capitalFlowCustomerDto);
  }

  /**
   * 客户-资金明细查询
   * @param capitalFlowCustomerDto
   * @return
   */
  public List<CapitalFlow> findByCapitalFlowCustomerDto(CapitalFlowCustomerDto capitalFlowCustomerDto) {
    return this.baseMapper.findByCapitalFlowCustomerDto(capitalFlowCustomerDto);
  }
}
