package com.biz.crm.dms.business.costpool.capital.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.dms.business.costpool.capital.local.entity.Capital;
import com.biz.crm.dms.business.costpool.capital.local.mapper.CapitalMapper;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalDto;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalPageDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * @description: 资金 的 数据库访问类 {@link Capital}
 * @author: rentao
 * @date: 2021/12/13 20:03
 */
@Component
public class CapitalRepository extends ServiceImpl<CapitalMapper, Capital> {

  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<Capital> findByConditions(Page<Capital> page, CapitalPageDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }

  /**
   * 客户编码查询资金主表
   *
   * @param cusCode
   * @author rentao
   * @date
   */
  public Capital findByCusCode(String cusCode) {
    if (StringUtils.isBlank(cusCode)) {
      return null;
    }
    return this.lambdaQuery()
        .eq(Capital::getCustomerCode, cusCode)
        .eq(Capital::getTenantCode, TenantUtils.getTenantCode())
        .eq(Capital::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .one();
  }

}
