package com.biz.crm.dms.business.costpool.capital.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.capital.local.entity.CapitalFlow;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalFlowDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @description: 资金流水service
 * @author: rentao
 * @date: 2021/12/13 20:03
 */
public interface CapitalFlowService {

  /**
   * 分页条件查询客户资金
   *
   * @param pageable 分页参数
   * @param dto 客户资金查询参数
   * @return 客户资金实体
   */
  Page<CapitalFlow> findByConditions(Pageable pageable, CapitalFlowDto dto);

  /**
   * 资金编码查询资金流水
   *
   * @param capitalFlowDto
   * @author rentao
   * @date
   */
  List<CapitalFlow> findByCapitalCode(CapitalFlowDto capitalFlowDto);

  /**
   * 新增资金流水(只做计算后保存)
   *
   * @param contractDto
   * @return
   */
  CapitalFlow create(CapitalFlowDto contractDto);
}
