package com.biz.crm.dms.business.costpool.capital.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.business.costpool.capital.local.entity.Capital;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalDto;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalPageDto;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CostPoolCapitalDto;
import org.springframework.data.domain.Pageable;

/**
 * @description: 客户资金service
 * @author: rentao
 * @date: 2021/12/13 20:03
 */
public interface CapitalService {

  /**
   * 新增客户资金
   *
   * @param capitalDto
   * @return
   */
  Capital create(CapitalDto capitalDto);

  /**
   * 调整
   *
   * @param costPoolCapitalDto
   */
  void handleAdjust(CostPoolCapitalDto costPoolCapitalDto);

  /**
   * 分页条件查询客户资金
   *
   * @param pageable 分页参数
   * @param dto 客户资金查询参数
   * @return 客户资金实体
   */
  Page<Capital> findByConditions(Pageable pageable, CapitalPageDto dto);

  /**
   *
   * 根据主键id查询
   * @param id
   * @author rentao
   * @date
   */
  Capital findById(String id);

  /**
   *
   * 根据customerCode查询
   * @param customerCode
   * @author rentao
   * @date
   */
  Capital findByCustomerCode(String customerCode);
}
