package com.biz.crm.dms.business.costpool.capital.local.service.internal;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalAdjustQueryDto;
import com.biz.crm.dms.business.costpool.capital.sdk.service.CapitalAdjustTypeVoService;
import com.biz.crm.dms.business.costpool.capital.sdk.strategy.CapitalOperationTypeStrategy;
import com.biz.crm.dms.business.costpool.capital.sdk.vo.CapitalAdjustTypeVo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @description: 资金调整类型service
 * @author: rentao
 * @date: 2022/3/17 11:19
 */
@Slf4j
@Service
public class CapitalAdjustTypeVoServiceImpl implements CapitalAdjustTypeVoService {

  @Autowired(required = false)
  private List<CapitalOperationTypeStrategy> capitalOperationTypeStrategies;

  /**
   * 资金编码查询资金流水
   *
   * @param capitalAdjustQueryDto
   */
  @Override
  public List<CapitalAdjustTypeVo> findCapitalAdjustTypeVo(
      CapitalAdjustQueryDto capitalAdjustQueryDto) {
    List<CapitalAdjustTypeVo> adjustTypeVos = new ArrayList<>();
    List<CapitalOperationTypeStrategy> collect = capitalOperationTypeStrategies.stream()
        .filter(capitalOperationTypeStrategy -> BooleanEnum.TRUE.getNumStr()
               .equals(capitalOperationTypeStrategy.getActiveType().getNumStr())
            && capitalOperationTypeStrategy.getAmanagementType().getNumStr()
                .equals(capitalAdjustQueryDto.getManagementType())
            && capitalOperationTypeStrategy.getInitType().getNumStr()
                .equals(capitalAdjustQueryDto.getInitType())
        ).collect(Collectors.toList());
    if(!CollectionUtils.isEmpty(collect)){
      collect.forEach(capitalOperationTypeStrategy -> {
        CapitalAdjustTypeVo capitalAdjustTypeVo = new CapitalAdjustTypeVo();
        capitalAdjustTypeVo.setAdjustType(capitalOperationTypeStrategy.getOperationTypeGroup());
        capitalAdjustTypeVo.setAdjustTypeName(capitalOperationTypeStrategy.getOperationTypeGroupName());
        adjustTypeVos.add(capitalAdjustTypeVo);
      });
    }

    return adjustTypeVos;
  }
}
