package com.biz.crm.dms.business.costpool.capital.local.service.internal;

import com.biz.crm.dms.business.costpool.capital.local.entity.CapitalFlowFile;
import com.biz.crm.dms.business.costpool.capital.local.repository.CapitalFlowFileRepository;
import com.biz.crm.dms.business.costpool.capital.local.service.CapitalFlowFileService;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalFlowFileDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * @description: 资金流水附件service
 * @author: rentao
 * @date: 2021/12/16 15:33
 */
@Slf4j
@Service
public class CapitalFlowFileServiceImpl implements CapitalFlowFileService {

  @Autowired(required = false) private CapitalFlowFileRepository capitalFlowFileRepository;

  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  @Transactional
  public void createBatch(List<CapitalFlowFileDto> capitalFlowFileDtos, String flowNo,String capitalCode) {
    Validate.isTrue(CollectionUtils.isNotEmpty(capitalFlowFileDtos), "资金附件不能为空");
    Validate.notBlank(flowNo, "资金流水编码不能为空");
    List<CapitalFlowFile> capitalFlowFiles =
        (List<CapitalFlowFile>)
            this.nebulaToolkitService.copyCollectionByWhiteList(
                capitalFlowFileDtos,
                CapitalFlowFileDto.class,
                CapitalFlowFile.class,
                HashSet.class,
                ArrayList.class);
    capitalFlowFiles.forEach(s->{
      s.setFlowNo(flowNo);
      s.setCapitalCode(capitalCode);
    });
    this.capitalFlowFileRepository.saveBatch(capitalFlowFiles);
  }
}
