package com.biz.crm.dms.business.costpool.capital.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.dms.business.costpool.capital.local.constant.CapitalConstant;
import com.biz.crm.dms.business.costpool.capital.local.entity.CapitalFlow;
import com.biz.crm.dms.business.costpool.capital.local.repository.CapitalFlowRepository;
import com.biz.crm.dms.business.costpool.capital.local.service.CapitalFlowFileService;
import com.biz.crm.dms.business.costpool.capital.local.service.CapitalFlowService;
import com.biz.crm.dms.business.costpool.capital.local.utils.CapitalFlowUtil;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalFlowDto;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.CapitalAdjustTypeEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

/**
 * @description: 资金流水service
 * @author: rentao
 * @date: 2021/12/13 20:04
 */
@Slf4j
@Service
public class CapitalFlowServiceImpl implements CapitalFlowService {

  @Autowired(required = false) private GenerateCodeService generateCodeService;

  @Autowired(required = false) private CapitalFlowFileService capitalFlowFileService;

  @Autowired(required = false) private CapitalFlowRepository capitalFlowRepository;

  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<CapitalFlow> findByConditions(Pageable pageable, CapitalFlowDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto = Optional.ofNullable(dto).orElse(new CapitalFlowDto());
    dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    Page<CapitalFlow> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.capitalFlowRepository.findByConditions(page, dto);
  }

  @Override
  public List<CapitalFlow> findByCapitalCode(CapitalFlowDto capitalFlowDto) {
    Validate.notNull(capitalFlowDto, "资金信息传入参数不能为空");
    Validate.notBlank(capitalFlowDto.getCapitalCode(), "资金编码必传");
    return this.capitalFlowRepository.findByCapitalFlowDto(capitalFlowDto);
  }

  @Override
  @Transactional
  public CapitalFlow create(CapitalFlowDto capitalFlowDto) {
    CapitalFlowUtil.validateAdd(capitalFlowDto);
    capitalFlowDto.setFlowNo(
        this.generateCodeService.generateCode(CapitalConstant.CAPITAL_FLOW_NO, 1).get(0));
    CapitalAdjustTypeEnum adjustTypeEnum =
        CapitalAdjustTypeEnum.getByKey(capitalFlowDto.getAdjustType());
    Validate.notNull(adjustTypeEnum, "传入类型不存在");
    CapitalFlow entity =
        this.nebulaToolkitService.copyObjectByWhiteList(
            capitalFlowDto, CapitalFlow.class, HashSet.class, ArrayList.class);
    entity.setId(null);
    // 流水顺序问题由调用时间来区分
    entity.setCreateTime(new Date());
    this.capitalFlowRepository.save(entity);
    if (CollectionUtils.isNotEmpty(capitalFlowDto.getCapitalFlowFileDtos())) {
      this.capitalFlowFileService.createBatch(
          capitalFlowDto.getCapitalFlowFileDtos(), capitalFlowDto.getFlowNo(),capitalFlowDto.getCapitalCode());
    }
    return entity;
  }
}
