package com.biz.crm.dms.business.costpool.capital.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.business.costpool.capital.local.entity.CapitalFlow;
import com.biz.crm.dms.business.costpool.capital.local.entity.CapitalFlowFile;
import com.biz.crm.dms.business.costpool.capital.local.repository.CapitalFlowFileRepository;
import com.biz.crm.dms.business.costpool.capital.local.repository.CapitalFlowRepository;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalFlowCustomerDto;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.CapitalAdjustGroupEnum;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.CapitalAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.capital.sdk.service.CapitalFlowVoService;
import com.biz.crm.dms.business.costpool.capital.sdk.vo.CapitalFlowFileVo;
import com.biz.crm.dms.business.costpool.capital.sdk.vo.CapitalFlowVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * @description: 资金流水Vo service
 * @author: rentao
 * @date: 2021/12/13 20:19
 */
@Slf4j
@Service
public class CapitalFlowVoServiceImpl implements CapitalFlowVoService {

  @Autowired(required = false) private CapitalFlowRepository capitalFlowRepository;

  @Autowired(required = false) private CapitalFlowFileRepository capitalFlowFileRepository;

  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Override
  public CapitalFlowVo findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    CapitalFlow capitalFlow = this.capitalFlowRepository.getById(id);
    if (capitalFlow == null) {
      return null;
    }
    CapitalFlowVo vo =
        this.nebulaToolkitService.copyObjectByWhiteList(
            capitalFlow, CapitalFlowVo.class, HashSet.class, ArrayList.class);
    List<CapitalFlowFile> capitalFlowFiles = this.capitalFlowFileRepository.findByFlowNo(vo.getFlowNo());
    if (CollectionUtils.isNotEmpty(capitalFlowFiles)) {
      List<CapitalFlowFileVo> capitalFlowFileVos =
          (List<CapitalFlowFileVo>)
              this.nebulaToolkitService.copyCollectionByWhiteList(
                  capitalFlowFiles,
                  CapitalFlowFile.class,
                  CapitalFlowFileVo.class,
                  HashSet.class,
                  ArrayList.class);
      vo.setCapitalFlowFileVos(capitalFlowFileVos);
    }
    return vo;
  }

  @Override
  public CapitalFlowVo findDetailsByFlowNo(String flowNo) {
    if (StringUtils.isBlank(flowNo)) {
      return null;
    }
    CapitalFlow capitalFlow = this.capitalFlowRepository.findByFlowNo(flowNo);
    if (capitalFlow == null) {
      return null;
    }
    CapitalFlowVo vo =
        this.nebulaToolkitService.copyObjectByWhiteList(
            capitalFlow, CapitalFlowVo.class, HashSet.class, ArrayList.class);
    List<CapitalFlowFile> capitalFlowFiles = this.capitalFlowFileRepository.findByFlowNo(vo.getFlowNo());
    if (CollectionUtils.isNotEmpty(capitalFlowFiles)) {
      List<CapitalFlowFileVo> capitalFlowFileVos =
          (List<CapitalFlowFileVo>)
              this.nebulaToolkitService.copyCollectionByWhiteList(
                  capitalFlowFiles,
                  CapitalFlowFile.class,
                  CapitalFlowFileVo.class,
                  HashSet.class,
                  ArrayList.class);
      vo.setCapitalFlowFileVos(capitalFlowFileVos);
    }
    return vo;
  }

  /**
   * 客户-资金明细分页查询
   * @param pageable
   * @param capitalFlowCustomerDto
   * @return
   */
  @Override
  public Page<CapitalFlowVo> findByCapitalFlowCustomerDto(Pageable pageable, CapitalFlowCustomerDto capitalFlowCustomerDto) {
    String customerCode = capitalFlowCustomerDto.getCustomerCode();
    if (StringUtils.isBlank(customerCode)) {
      Page<CapitalFlowVo> pageResult = new Page<>(0L, 0L, 0L);
      return pageResult;
    }
    capitalFlowCustomerDto.setCustomerCode(customerCode);
    Validate.notBlank(capitalFlowCustomerDto.getGroup(),"上账/使用标识不能为空");
    CapitalAdjustGroupEnum capitalAdjustGroupEnum = CapitalAdjustGroupEnum.getByKey(capitalFlowCustomerDto.getGroup());
    Validate.isTrue(!ObjectUtils.isEmpty(capitalAdjustGroupEnum),"上账/使用标识错误");
    List<String> adjustTypeList = CapitalAdjustTypeEnum.getDictCodeByGroupEnum(capitalAdjustGroupEnum);
    capitalFlowCustomerDto.setAdjustTypeList(adjustTypeList);
    //查询
    pageable = org.apache.commons.lang3.ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    Page<CapitalFlow> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    capitalFlowCustomerDto.setTenantCode(TenantUtils.getTenantCode());
    Page<CapitalFlow> entityResult = this.capitalFlowRepository.findByCapitalFlowCustomerDto(page, capitalFlowCustomerDto);
    Page<CapitalFlowVo> pageResult = new Page<>(entityResult.getCurrent(), entityResult.getSize(), entityResult.getTotal());
    if (CollectionUtils.isEmpty(entityResult.getRecords())) {
      return pageResult;
    }
    //转换列表结果
    List<CapitalFlowVo> list = Lists.newArrayList(this.nebulaToolkitService
        .copyCollectionByBlankList(entityResult.getRecords(), CapitalFlow.class, CapitalFlowVo.class, HashSet.class, ArrayList.class));
    pageResult.setRecords(list);
    return pageResult;
  }


  @Override
  public List<CapitalFlowVo> findByCapitalFlowCustomerDto(
      CapitalFlowCustomerDto capitalFlowCustomerDto) {
    capitalFlowCustomerDto.setTenantCode(TenantUtils.getTenantCode());
    List<CapitalFlow> entityResult = this.capitalFlowRepository.findByCapitalFlowCustomerDto(capitalFlowCustomerDto);
    //转换列表结果
    List<CapitalFlowVo> list = Lists.newArrayList(this.nebulaToolkitService
        .copyCollectionByBlankList(entityResult, CapitalFlow.class, CapitalFlowVo.class, HashSet.class, ArrayList.class));
    return list;
  }
}
