package com.biz.crm.dms.business.costpool.capital.local.service.notifier;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.pay.business.sdk.dto.PayEventDto;
import com.biz.crm.common.pay.business.sdk.event.PayEventListener;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CostPoolCapitalDto;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.CapitalAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.PoolTypeEnum;
import com.biz.crm.dms.business.costpool.sdk.service.CostPoolVoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年09月01日 11:19:00
 */
@Component
@Slf4j
public class CreditPayEventListenerImpl implements PayEventListener {

  @Autowired(required = false)
  private CostPoolVoService costPoolVoService;


  /**
   *未支付
   * @param dto
   */
  @Override
  public void onUnpaid(PayEventDto dto) {

  }

  /**
   * 执行中
   * @param dto
   */
  @Override
  public void onProcessing(PayEventDto dto) {

  }

  /**
   * 成功
   * @param dto
   */
  @Override
  public void onSuccess(PayEventDto dto) {
    //调整 资金
    JSONArray array = new JSONArray();
    /**
     * 构建资金dto
     */
    CostPoolCapitalDto costPoolCapitalDto = new CostPoolCapitalDto();
    costPoolCapitalDto.setPoolType(PoolTypeEnum.CAPITAL.getKey());
    costPoolCapitalDto.setCustomerCode(dto.getCustomerCode());
    costPoolCapitalDto.setFromDesc(CapitalAdjustTypeEnum.RECHARGE_AMOUNT.getValue());
    costPoolCapitalDto.setAmount(dto.getAmount());
    costPoolCapitalDto.setAdjustMoney(dto.getAmount());
    costPoolCapitalDto.setAdjustType(CapitalAdjustTypeEnum.RECHARGE_AMOUNT.getKey());
    costPoolCapitalDto.setAdjustTypeName(CapitalAdjustTypeEnum.RECHARGE_AMOUNT.getValue());
    array.add(dto);
    //费用池执行
    costPoolVoService.handleAdjust(array);
  }

  /**
   * 失败
   * @param dto
   */
  @Override
  public void onFailure(PayEventDto dto) {

  }

  /**
   * 关闭
   * @param dto
   */
  @Override
  public void onClose(PayEventDto dto) {

  }
}
