package com.biz.crm.dms.business.costpool.capital.local.service.observer;

import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalFlowCustomerDto;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.CapitalAdjustGroupEnum;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.CapitalAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.PoolTypeEnum;
import com.biz.crm.dms.business.costpool.capital.sdk.service.CapitalFlowVoService;
import com.biz.crm.dms.business.costpool.capital.sdk.vo.CapitalFlowVo;
import com.biz.crm.dms.business.costpool.sdk.enums.CostPoolSummaryEnum;
import com.biz.crm.dms.business.costpool.sdk.observer.CostPoolAmountStatisticsObserver;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolAmountStatisticsVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @description: 费用池金额统计客户资金观察者
 * @author: rentao
 * @date: 2022/4/11 11:16
 */
@Service
@Slf4j
public class CostPoolAmountStatisticsCapitalImpl implements CostPoolAmountStatisticsObserver {

  @Autowired(required = false)
  private CapitalFlowVoService capitalFlowVoService;

  @Override
  public List<CostPoolAmountStatisticsVo> findAmountStatisticsVoByCustomerCodeAndDate(
      String customerCode, Date beginDate, Date endDate) {
    Validate.notBlank(customerCode,"客户编码不存在");
    Validate.notNull(beginDate,"请输入对账开始时间");
    Validate.notNull(endDate,"请输入对账结束时间");
    List<CostPoolAmountStatisticsVo> list = new ArrayList<>();
    BigDecimal startCount = this.startCount(customerCode, beginDate, endDate);
    BigDecimal endCount = this.endCount(customerCode, beginDate, endDate);
    CapitalFlowCustomerDto capitalFlowCustomerDto = new CapitalFlowCustomerDto();
    capitalFlowCustomerDto.setCustomerCode(customerCode);
    capitalFlowCustomerDto.setEndTime(endDate);
    capitalFlowCustomerDto.setStartTime(beginDate);
    List<CapitalFlowVo> capitalFlowVos = this.capitalFlowVoService.findByCapitalFlowCustomerDto(capitalFlowCustomerDto);
    //流水
    for (CostPoolSummaryEnum costPoolSummaryEnum : CostPoolSummaryEnum.values()) {
      CostPoolAmountStatisticsVo costPoolAmountStatisticsVo = new CostPoolAmountStatisticsVo();
      costPoolAmountStatisticsVo.setPoolType(PoolTypeEnum.CAPITAL.getKey());
      costPoolAmountStatisticsVo.setSummary(costPoolSummaryEnum.getKey());
      if (CostPoolSummaryEnum.OCCUPY.getKey().equals(costPoolSummaryEnum.getKey())) {
        //占用释放金额
        BigDecimal decimal = capitalFlowVos.stream()
            .filter(f->CapitalAdjustTypeEnum.OCCUPY_USE.getKey().equals(f.getAdjustType())
                || CapitalAdjustTypeEnum.OCCUPY_RELEASE.getKey().equals(f.getAdjustType()))
            .map(CapitalFlowVo::getAdjustMoney)
            .reduce(BigDecimal.ZERO, BigDecimal::add);
        costPoolAmountStatisticsVo.setTotalAmount(decimal);
      } else {
        BigDecimal decimal = this.countAmount(capitalFlowVos, costPoolSummaryEnum);
        //使用上账金额
        costPoolAmountStatisticsVo.setTotalAmount(decimal);
        //期初期末
        if(costPoolSummaryEnum.getKey().equals(CostPoolSummaryEnum.BEGIN.getKey())){
          costPoolAmountStatisticsVo.setTotalAmount(startCount);
        }
        if(costPoolSummaryEnum.getKey().equals(CostPoolSummaryEnum.END.getKey())){
          if(endCount == null){
            costPoolAmountStatisticsVo.setTotalAmount(startCount);
          }else {
            costPoolAmountStatisticsVo.setTotalAmount(endCount);
          }
        }
      }
      list.add(costPoolAmountStatisticsVo);
    }
    return list;
  }

  /**
   *
   * </br>
   * @param capitalFlowVos
   * @param costPoolSummaryEnum
   * @author rentao
   * @date
   */
  private BigDecimal countAmount(List<CapitalFlowVo> capitalFlowVos,CostPoolSummaryEnum costPoolSummaryEnum){
    if(CollectionUtils.isEmpty(capitalFlowVos)){ return BigDecimal.ZERO; }
    List<String> list = new ArrayList<>();
    if(costPoolSummaryEnum.getKey().equals(CostPoolSummaryEnum.ON.getKey())){
      list.addAll(CapitalAdjustTypeEnum.getDictCodeByGroupEnum(CapitalAdjustGroupEnum.ON));
    }
    if(costPoolSummaryEnum.getKey().equals(CostPoolSummaryEnum.USE.getKey())){
      list.addAll(CapitalAdjustTypeEnum.getDictCodeByGroupEnum(CapitalAdjustGroupEnum.USE));
    }
    //统计汇总金额
    List<CapitalFlowVo> capitalFlows = capitalFlowVos.stream()
        .filter(capitalFlowVo -> list.contains(capitalFlowVo.getAdjustType())).collect(
            Collectors.toList());
    //如果有冻结解冻 正为 负 负为上账
    if(CollectionUtils.isEmpty(capitalFlowVos)){ return BigDecimal.ZERO; }
    BigDecimal count = BigDecimal.ZERO;
    for (CapitalFlowVo capitalFlow : capitalFlows) {
      if(capitalFlow.getAdjustType().equals(CapitalAdjustTypeEnum.FREEZE_UNFREEZE.getKey())){
        count = count.subtract(capitalFlow.getAdjustMoney());
      }else {
        count = count.add(capitalFlow.getAdjustMoney());
      }
    }
    return count;
  }

  /**
   *
   * 期初金额
   * @param customerCode
   * @param beginDate
   * @param endDate
   * @author rentao
   * @date
   */
  private BigDecimal startCount(String customerCode, Date beginDate, Date endDate){
    CapitalFlowCustomerDto capitalDto = new CapitalFlowCustomerDto();
    capitalDto.setCustomerCode(customerCode);
    //期初金额 开始时间前第一条数据
    capitalDto.setEndTime(beginDate);
    capitalDto.setStartTime(null);
    List<CapitalFlowVo> capitalList = this.capitalFlowVoService.findByCapitalFlowCustomerDto(capitalDto);
    if(!CollectionUtils.isEmpty(capitalList)){
      CapitalFlowVo capital = capitalList.get(0);
      return capital.getCapitalAbleTotal();
    }
    return BigDecimal.ZERO;
  }

 /**
  *
  * 期末金额
  * @param customerCode
  * @param beginDate
  * @param endDate
  * @author rentao
  * @date
  */
  private BigDecimal endCount(String customerCode, Date beginDate, Date endDate){
    CapitalFlowCustomerDto capitalDto = new CapitalFlowCustomerDto();
    capitalDto.setStartTime(beginDate);
    capitalDto.setEndTime(endDate);
    capitalDto.setCustomerCode(customerCode);
    //期末
    List<CapitalFlowVo> capitalList = this.capitalFlowVoService.findByCapitalFlowCustomerDto(capitalDto);
    if(!CollectionUtils.isEmpty(capitalList)){
      CapitalFlowVo capitalFlowVo = capitalList.get(0);
      return capitalFlowVo.getCapitalAbleTotal();
    }else {
      return  null;
    }
  }

}
