package com.biz.crm.dms.business.costpool.capital.local.service.observer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.dms.business.costpool.capital.local.entity.Capital;
import com.biz.crm.dms.business.costpool.capital.local.service.CapitalService;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CostPoolCapitalDto;
import com.biz.crm.dms.business.costpool.capital.sdk.vo.CapitalCostPoolVo;
import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolRegister;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolStrategy;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolVo;
import com.bizunited.nebula.common.util.JsonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

/**
 * @description: 客户资金池实现费用池观察者相关接口
 * @author: rentao
 * @date: 2022/1/20 10:13
 */
@Component
public class CostPoolCapitalStrategyImpl implements CostPoolStrategy {

  @Autowired(required = false)
  @Qualifier("costPoolCapitalRegisterImpl")
  private CostPoolRegister costPoolRegister;

  @Autowired(required = false)
  private CapitalService capitalService;


  @Override
  public String getPoolTypeRegisterKey() {
    return costPoolRegister.getKey();
  }

  @Override
  public List<CostPoolVo> onRequestCostPoolVos(CostPoolDto costPoolDto) {
    if (Objects.isNull(costPoolDto)) {
      return null;
    }
    if (!StringUtils.equals(costPoolDto.getPoolType(), this.costPoolRegister.getKey())) {
      return null;
    }
    Capital capital = this.capitalService.findByCustomerCode(costPoolDto.getCustomerCode());
    if (Objects.isNull(capital)) {
      return new ArrayList<>(0);
    }
    CapitalCostPoolVo costPoolVo = new CapitalCostPoolVo();
    costPoolVo.setPoolCode(capital.getCapitalCode());
    costPoolVo.setCustomerCode(capital.getCustomerCode());
    costPoolVo.setCustomerName(capital.getCustomerName());
    costPoolVo.setTotalAmount(capital.getCapitalTotal());
    costPoolVo.setFreezeAmount(capital.getFrozeMoney());
    costPoolVo.setUsableAmount(capital.getCapitalAbleTotal());
    return Collections.singletonList(costPoolVo);
  }

  @Override
  public void onHandleAdjust(JSONObject jsonObject) {
    Validate.notNull(jsonObject,"客户资金池数据不能为空");
    CostPoolCapitalDto costPoolCapitalDto = JsonUtils.json2Obj(jsonObject.toJSONString(), CostPoolCapitalDto.class);
    Validate.notBlank(costPoolCapitalDto.getPoolType(), "调整时，费用池类型不能为空！");
    Validate.notNull(costPoolCapitalDto.getAdjustType(),"客户资金调整类型不能为空");
    Validate.notNull(costPoolCapitalDto.getAmount(), "调整时，金额不能为空！");
    costPoolCapitalDto.setAdjustMoney(costPoolCapitalDto.getAmount());
    this.capitalService.handleAdjust(costPoolCapitalDto);

  }
}
