package com.biz.crm.dms.business.costpool.capital.local.service.strategy;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.dms.business.costpool.capital.local.constant.CapitalConstant;
import com.biz.crm.dms.business.costpool.capital.local.entity.Capital;
import com.biz.crm.dms.business.costpool.capital.local.service.CapitalService;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalDto;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CostPoolCapitalDto;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.CapitalAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.capital.sdk.strategy.CapitalOperationTypeStrategy;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @description: 客户资金初始化 CapitalAdjustTypeEnum 资金操作类型枚举
 * @author: rentao
 * @date: 2022/3/14 12:23
 */
@Service
public class CapitalOperationTypeInitStrategy implements CapitalOperationTypeStrategy {

  @Autowired(required = false)
  private CapitalService capitalService;
  @Autowired(required = false)
  private CustomerVoService customerVoService;
  @Autowired(required = false)
  private GenerateCodeService generateCodeService;

  @Override
  public String getOperationTypeGroup() {
    return CapitalAdjustTypeEnum.INIT.getKey();
  }

  @Override
  public String getOperationTypeGroupName() {
    return CapitalAdjustTypeEnum.INIT.getValue();
  }

  @Override
  @Transactional
  public void onSaveCapitalInfos(CostPoolCapitalDto costPoolCapitalDto) {
    CustomerVo customerVo = this.customerVoService
        .findDetailsByIdOrCode(null, costPoolCapitalDto.getCustomerCode());
    Validate.notNull(customerVo, "客户不存在");
    Capital capital = this.capitalService.findByCustomerCode(costPoolCapitalDto.getCustomerCode());
    Validate.isTrue(Objects.isNull(capital), "已有对应客户资金存在不能初始化资金池！");
    CapitalDto capitalDto = this.transformDataAdd(costPoolCapitalDto,customerVo);
    this.capitalService.create(capitalDto);
  }

  /**
   *
   * 是否主动（页面展示）
   * @author rentao
   * @date
   */
  @Override
  public BooleanEnum getActiveType() {
    return BooleanEnum.TRUE;
  }

  /**
   *
   * 是否管理端（是，后台，否经销商页面调用）
   * @author rentao
   * @date
   */
  @Override
  public BooleanEnum getAmanagementType() {
    return BooleanEnum.TRUE;
  }

  /**
   *
   * 是否初始化客户资金
   * @author rentao
   * @date
   */
  @Override
  public BooleanEnum getInitType() {
    return BooleanEnum.TRUE;
  }

  /**
   * 初始化数据组装
   *
   * @param customerVo
   * @param costPoolCapitalDto
   * @author rentao
   * @date
   */
  private CapitalDto transformDataAdd(CostPoolCapitalDto costPoolCapitalDto,
      CustomerVo customerVo) {
    CapitalDto capitalDto = new CapitalDto();
    capitalDto.setCusOrgCode(customerVo.getCustomerOrgCode());
    capitalDto.setCusOrgName(customerVo.getCustomerOrgName());
    capitalDto.setCustomerCode(customerVo.getCustomerCode());
    capitalDto.setCustomerName(customerVo.getCustomerName());
    capitalDto.setCapitalCode(this.generateCodeService.generateCode(CapitalConstant.CAPITAL_CODE, 1).get(0));
    capitalDto.setTenantCode(TenantUtils.getTenantCode());
    capitalDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    capitalDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    capitalDto.setFrozeMoney(BigDecimal.ZERO);
    capitalDto.setUseMoney(BigDecimal.ZERO);
    capitalDto.setCapitalAbleTotal(costPoolCapitalDto.getAdjustMoney());
    capitalDto.setCapitalTotal(costPoolCapitalDto.getAdjustMoney());
    capitalDto.setAdjustMoney(costPoolCapitalDto.getAdjustMoney());
    capitalDto.setAdjustType(CapitalAdjustTypeEnum.INIT.getKey());
    capitalDto.setAdjustTypeName(CapitalAdjustTypeEnum.INIT.getValue());
    if(StringUtils.isNotBlank(costPoolCapitalDto.getBillNo())){
      capitalDto.setBillNo(costPoolCapitalDto.getBillNo());
      capitalDto.setBillType(costPoolCapitalDto.getBillType());
    }else {
      capitalDto.setBillNo(costPoolCapitalDto.getFromCode());
      capitalDto.setBillType(costPoolCapitalDto.getFromDesc());
    }
    return capitalDto;
  }

}
