package com.biz.crm.dms.business.costpool.capital.local.service.strategy;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.dms.business.costpool.capital.local.entity.Capital;
import com.biz.crm.dms.business.costpool.capital.local.service.CapitalService;
import com.biz.crm.dms.business.costpool.capital.local.utils.CapitalOperationTypeUtil;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalDto;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CostPoolCapitalDto;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.CapitalAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.capital.sdk.strategy.CapitalOperationTypeStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @description: 订单关闭
 * @author: rentao
 * @date: 2022/3/15 14:48
 */
@Service
public class CapitalOperationTypeOrderCloseStrategy implements CapitalOperationTypeStrategy {

  @Autowired(required = false)
  private CapitalService capitalService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public String getOperationTypeGroup() {
    return CapitalAdjustTypeEnum.ORDER_CLOSE.getKey();
  }

  @Override
  public String getOperationTypeGroupName() {
    return CapitalAdjustTypeEnum.ORDER_CLOSE.getValue();
  }

  @Override
  public void onSaveCapitalInfos(CostPoolCapitalDto costPoolCapitalDto) {
    CapitalOperationTypeUtil.validateCostPoolCapitalDto(costPoolCapitalDto);
    Capital capital = this.capitalService.findByCustomerCode(costPoolCapitalDto.getCustomerCode());
    Validate.notNull(capital, "对应客户资金不存在不能编辑");
    CapitalDto capitalDto = this.transformDataUpdate(capital, costPoolCapitalDto);
    this.capitalService.create(capitalDto);
  }

  /**
   *
   * 是否主动（页面展示）
   * @author rentao
   * @date
   */
  @Override
  public BooleanEnum getActiveType() {
    return BooleanEnum.FALSE;
  }

  /**
   *
   * 是否初始化客户资金
   * @author rentao
   * @date
   */
  @Override
  public BooleanEnum getInitType() {
    return BooleanEnum.FALSE;
  }

  /**
   * 资金调整数据组装
   * 总金额不变 余额变动 冻结金额不变 使用金额变动
   * @param capital
   * @param costPoolCapitalDto
   * @author rentao
   * @date
   */
  private CapitalDto transformDataUpdate(Capital capital, CostPoolCapitalDto costPoolCapitalDto) {
    CapitalDto capitalDto =
        this.nebulaToolkitService
            .copyObjectByWhiteList(capital, CapitalDto.class, HashSet.class, ArrayList.class);
    // 操作金额
    BigDecimal adjustMoney = costPoolCapitalDto.getAdjustMoney();
    // 资金可用余额
    BigDecimal capitalAbleTotal = capital.getCapitalAbleTotal();
    // 资金可用余额 (当前)
    BigDecimal capitalAbleTotalNew = capitalAbleTotal.add(adjustMoney);
    //已使用（当前）
    BigDecimal useMoneyNew = capital.getUseMoney().subtract(adjustMoney);
    Validate.isTrue(capitalAbleTotalNew.compareTo(BigDecimal.ZERO) >= 0, "可用余额不能小于零。");
    capitalDto.setCapitalAbleTotal(capitalAbleTotalNew);
    capitalDto.setUseMoney(useMoneyNew);
    capitalDto.setAdjustMoney(adjustMoney);
    capitalDto.setAdjustType(costPoolCapitalDto.getAdjustType());
    capitalDto.setAdjustTypeName(CapitalAdjustTypeEnum.ORDER_CLOSE.getValue());
    capitalDto.setCapitalFlowFileDtos(costPoolCapitalDto.getCapitalFlowFileDtos());
    if(StringUtils.isNotBlank(costPoolCapitalDto.getBillNo())){
      capitalDto.setBillNo(costPoolCapitalDto.getBillNo());
      capitalDto.setBillType(costPoolCapitalDto.getBillType());
    }else {
      capitalDto.setBillNo(costPoolCapitalDto.getFromCode());
      capitalDto.setBillType(costPoolCapitalDto.getFromDesc());
    }
    return capitalDto;
  }

}
