package com.biz.crm.dms.business.costpool.capital.local.service.strategy;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.dms.business.costpool.capital.local.entity.Capital;
import com.biz.crm.dms.business.costpool.capital.local.service.CapitalService;
import com.biz.crm.dms.business.costpool.capital.local.utils.CapitalOperationTypeUtil;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalDto;
import com.biz.crm.dms.business.costpool.capital.sdk.dto.CostPoolCapitalDto;
import com.biz.crm.dms.business.costpool.capital.sdk.enums.CapitalAdjustTypeEnum;
import com.biz.crm.dms.business.costpool.capital.sdk.strategy.CapitalOperationTypeStrategy;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description: 退货退款
 * @author: rentao
 * @date: 2022/5/25 16:45
 */
@Service
public class CapitalOperationTypeReturnedGoodsStrategy implements CapitalOperationTypeStrategy {

  @Autowired(required = false)
  private CapitalService capitalService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  /**
   * 操作类型分组编码(上账)
   * @return
   */
  @Override
  public String getOperationTypeGroup() {
    return CapitalAdjustTypeEnum.RETURNED_GOODS_AMOUNT.getKey();
  }

  @Override
  public String getOperationTypeGroupName() {
    return CapitalAdjustTypeEnum.RETURNED_GOODS_AMOUNT.getValue();
  }

  /**
   * 上账
   * @param costPoolCapitalDto
   * @return
   */
  @Override
  @Transactional
  public void onSaveCapitalInfos(CostPoolCapitalDto costPoolCapitalDto) {
    //调整资金池 验证
    CapitalOperationTypeUtil.validateCostPoolCapitalDto(costPoolCapitalDto);
    Capital capital = this.capitalService.findByCustomerCode(costPoolCapitalDto.getCustomerCode());
    Validate.notNull(capital, "对应客户资金不存在不能编辑");
    CapitalDto capitalDto = this.transformDataUpdate(capital, costPoolCapitalDto);
    this.capitalService.create(capitalDto);
  }

  /**
   *
   * 是否主动（页面展示）
   * @author rentao
   * @date
   */
  @Override
  public BooleanEnum getActiveType() {
    return BooleanEnum.FALSE;
  }

  /**
   *
   * 是否管理端（是，后台，否经销商页面调用）
   * @author rentao
   * @date
   */
  @Override
  public BooleanEnum getAmanagementType() {
    return BooleanEnum.FALSE;
  }

  /**
   *
   * 是否初始化客户资金
   * @author rentao
   * @date
   */
  @Override
  public BooleanEnum getInitType() {
    return BooleanEnum.FALSE;
  }


  /**
   * 资金调整数据组装 为正总金额变动 余额变动 冻结金额不变 使用金额不变  总 = 余额+冻结+使用
   * 资金调整数据组装 为负总金额不变 余额变动 冻结金额不变 使用金额变动
   *
   * @param capital
   * @param costPoolCapitalDto
   * @author rentao
   * @date
   */
  private CapitalDto transformDataUpdate(Capital capital, CostPoolCapitalDto costPoolCapitalDto) {
    CapitalDto capitalDto =
        this.nebulaToolkitService
            .copyObjectByWhiteList(capital, CapitalDto.class, HashSet.class, ArrayList.class);
    // 操作金额
    BigDecimal adjustMoney = costPoolCapitalDto.getAdjustMoney();
    //可用余额
    BigDecimal capitalAbleTotal = capital.getCapitalAbleTotal();
    BigDecimal capitalTotal = capital.getCapitalTotal();
    //新的可用余额
    BigDecimal capitalAbleTotalNew = capitalAbleTotal.add(adjustMoney);
    BigDecimal capitalTotalNew = capitalTotal.add(adjustMoney);
    Validate.isTrue(capitalAbleTotalNew.compareTo(BigDecimal.ZERO) >= 0, "上账后可用余额不能小于零！");
    //上账金额不能为零
    Validate.isTrue(adjustMoney.compareTo(BigDecimal.ZERO) != 0, "调整金额不能等于零！");
    // 总金额加本次操作金额
    capitalDto.setCapitalTotal(capitalTotalNew);
    capitalDto.setCapitalAbleTotal(capitalAbleTotalNew);
    capitalDto.setAdjustMoney(adjustMoney);
    capitalDto.setAdjustType(costPoolCapitalDto.getAdjustType());
    capitalDto.setAdjustTypeName(CapitalAdjustTypeEnum.RETURNED_GOODS_AMOUNT.getValue());
    capitalDto.setCapitalFlowFileDtos(costPoolCapitalDto.getCapitalFlowFileDtos());
    if(StringUtils.isNotBlank(costPoolCapitalDto.getBillNo())){
      capitalDto.setBillNo(costPoolCapitalDto.getBillNo());
      capitalDto.setBillType(costPoolCapitalDto.getBillType());
    }else {
      capitalDto.setBillNo(costPoolCapitalDto.getFromCode());
      capitalDto.setBillType(costPoolCapitalDto.getFromDesc());
    }
    return capitalDto;
  }
}