package com.biz.crm.dms.business.costpool.capital.local.utils;

import com.biz.crm.dms.business.costpool.capital.sdk.dto.CapitalFlowDto;
import org.apache.commons.lang3.Validate;

/**
 * @description: 资金util
 * @author: rentao
 * @date: 2021/12/13 20:04
 */
public class CapitalFlowUtil {

  /**
   * 校验新增
   *
   * @param capitalFlowDto
   */
  public static void validateAdd(CapitalFlowDto capitalFlowDto) {
    Validate.notNull(capitalFlowDto, "资金信息不能为空");
    Validate.notBlank(capitalFlowDto.getCustomerCode(), "客户编码不能为空");
    Validate.notBlank(capitalFlowDto.getCustomerName(), "客户名称不能为空");
  }
}
